/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.research.Knowledge;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.ResearchStage;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.util.InventoryUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncProgressPacket
implements IMessageToServer {
    private static final Logger LOGGER = LogManager.getLogger();
    protected SimpleResearchKey key;
    protected boolean firstSync;
    protected boolean runChecks;
    protected boolean noFlags;
    protected boolean noPopups;

    public SyncProgressPacket() {
        this.key = null;
        this.firstSync = false;
        this.runChecks = false;
        this.noFlags = false;
        this.noPopups = false;
    }

    public SyncProgressPacket(SimpleResearchKey key, boolean firstSync, boolean runChecks, boolean noFlags, boolean noPopups) {
        this.key = key;
        this.firstSync = firstSync;
        this.runChecks = runChecks;
        this.noFlags = noFlags;
        this.noPopups = noPopups;
    }

    public static void encode(SyncProgressPacket message, FriendlyByteBuf buf) {
        buf.m_130070_(message.key.getRootKey());
        buf.writeBoolean(message.firstSync);
        buf.writeBoolean(message.runChecks);
        buf.writeBoolean(message.noFlags);
        buf.writeBoolean(message.noPopups);
    }

    public static SyncProgressPacket decode(FriendlyByteBuf buf) {
        SyncProgressPacket message = new SyncProgressPacket();
        message.key = SimpleResearchKey.parse(buf.m_130277_());
        message.firstSync = buf.readBoolean();
        message.runChecks = buf.readBoolean();
        message.noFlags = buf.readBoolean();
        message.noPopups = buf.readBoolean();
        return message;
    }

    public static class Handler {
        public static void onMessage(SyncProgressPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player;
                if (message.key != null && message.firstSync != message.key.isKnownBy((Player)(player = ((NetworkEvent.Context)ctx.get()).getSender()))) {
                    if (message.runChecks && !Handler.checkAndConsumePrerequisites((Player)player, message.key)) {
                        return;
                    }
                    LOGGER.debug("Progressing research {} for player {}", (Object)message.key.getRootKey(), (Object)player.m_7755_().getString());
                    ResearchManager.progressResearch((Player)player, message.key, true, !message.noFlags, !message.noPopups);
                }
            });
            ctx.get().setPacketHandled(true);
        }

        protected static boolean checkAndConsumePrerequisites(Player player, SimpleResearchKey key) {
            ResearchEntry entry = ResearchEntries.getEntry(key);
            if (entry == null || entry.getStages().isEmpty()) {
                return true;
            }
            IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge(player).orElse(null);
            if (knowledge == null) {
                return false;
            }
            int currentStageNum = knowledge.getResearchStage(key);
            if (currentStageNum < 0) {
                return false;
            }
            if (currentStageNum >= entry.getStages().size()) {
                return true;
            }
            ResearchStage stage = entry.getStages().get(currentStageNum);
            boolean retVal = stage.arePrerequisitesMet(player);
            if (retVal) {
                for (Object obj : stage.getMustObtain()) {
                    if (obj instanceof ItemStack) {
                        InventoryUtils.consumeItem(player, (ItemStack)obj);
                        continue;
                    }
                    if (!(obj instanceof ResourceLocation)) continue;
                    InventoryUtils.consumeItem(player, (ResourceLocation)obj, 1);
                }
                for (Knowledge know : stage.getRequiredKnowledge()) {
                    ResearchManager.addKnowledge(player, know.getType(), -(know.getAmount() * know.getType().getProgression()));
                }
            }
            return retVal;
        }
    }
}

