/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SyncResearchFlagsPacket
implements IMessageToServer {
    protected SimpleResearchKey key = null;
    protected boolean isNew = false;
    protected boolean isUpdated = false;
    protected boolean isPopup = false;

    public SyncResearchFlagsPacket() {
    }

    public SyncResearchFlagsPacket(Player player, SimpleResearchKey key) {
        this();
        this.key = key;
        PrimalMagickCapabilities.getKnowledge(player).ifPresent(knowledge -> {
            this.isNew = knowledge.hasResearchFlag(key, IPlayerKnowledge.ResearchFlag.NEW);
            this.isUpdated = knowledge.hasResearchFlag(key, IPlayerKnowledge.ResearchFlag.UPDATED);
            this.isPopup = knowledge.hasResearchFlag(key, IPlayerKnowledge.ResearchFlag.POPUP);
        });
    }

    public static void encode(SyncResearchFlagsPacket message, FriendlyByteBuf buf) {
        buf.m_130070_(message.key.getRootKey());
        buf.writeBoolean(message.isNew);
        buf.writeBoolean(message.isUpdated);
        buf.writeBoolean(message.isPopup);
    }

    public static SyncResearchFlagsPacket decode(FriendlyByteBuf buf) {
        SyncResearchFlagsPacket message = new SyncResearchFlagsPacket();
        message.key = SimpleResearchKey.parse(buf.m_130277_());
        message.isNew = buf.readBoolean();
        message.isUpdated = buf.readBoolean();
        message.isPopup = buf.readBoolean();
        return message;
    }

    public static class Handler {
        public static void onMessage(SyncResearchFlagsPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (message.key != null) {
                    ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                    PrimalMagickCapabilities.getKnowledge((Player)player).ifPresent(knowledge -> {
                        if (message.isNew) {
                            knowledge.addResearchFlag(message.key, IPlayerKnowledge.ResearchFlag.NEW);
                        } else {
                            knowledge.removeResearchFlag(message.key, IPlayerKnowledge.ResearchFlag.NEW);
                        }
                        if (message.isUpdated) {
                            knowledge.addResearchFlag(message.key, IPlayerKnowledge.ResearchFlag.UPDATED);
                        } else {
                            knowledge.removeResearchFlag(message.key, IPlayerKnowledge.ResearchFlag.UPDATED);
                        }
                        if (message.isPopup) {
                            knowledge.addResearchFlag(message.key, IPlayerKnowledge.ResearchFlag.POPUP);
                        } else {
                            knowledge.removeResearchFlag(message.key, IPlayerKnowledge.ResearchFlag.POPUP);
                        }
                    });
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

