/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerStats;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class SyncStatsPacket
implements IMessageToClient {
    protected CompoundTag data;

    public SyncStatsPacket() {
        this.data = null;
    }

    public SyncStatsPacket(Player player) {
        IPlayerStats stats = PrimalMagickCapabilities.getStats(player);
        this.data = stats != null ? (CompoundTag)stats.serializeNBT() : null;
    }

    public static void encode(SyncStatsPacket message, FriendlyByteBuf buf) {
        buf.m_130079_(message.data);
    }

    public static SyncStatsPacket decode(FriendlyByteBuf buf) {
        SyncStatsPacket message = new SyncStatsPacket();
        message.data = buf.m_130260_();
        return message;
    }

    public static class Handler {
        public static void onMessage(SyncStatsPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Object player = FMLEnvironment.dist == Dist.CLIENT ? ClientUtils.getCurrentPlayer() : null;
                IPlayerStats stats = PrimalMagickCapabilities.getStats(player);
                if (stats != null) {
                    stats.deserializeNBT((Tag)message.data);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

