/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class SyncWardPacket
implements IMessageToClient {
    protected CompoundTag data;

    public SyncWardPacket() {
        this.data = null;
    }

    public SyncWardPacket(Player player) {
        PrimalMagickCapabilities.getWard(player).ifPresent(ward -> {
            this.data = (CompoundTag)ward.serializeNBT();
        });
    }

    public static void encode(SyncWardPacket message, FriendlyByteBuf buf) {
        buf.m_130079_(message.data);
    }

    public static SyncWardPacket decode(FriendlyByteBuf buf) {
        SyncWardPacket message = new SyncWardPacket();
        message.data = buf.m_130260_();
        return message;
    }

    public static class Handler {
        public static void onMessage(SyncWardPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Player player;
                Object object = player = FMLEnvironment.dist == Dist.CLIENT ? ClientUtils.getCurrentPlayer() : null;
                if (player != null) {
                    PrimalMagickCapabilities.getWard(player).ifPresent(ward -> ward.deserializeNBT((Tag)message.data));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

