/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class TileToClientPacket
implements IMessageToClient {
    protected BlockPos pos;
    protected CompoundTag data;

    public TileToClientPacket() {
        this.pos = BlockPos.f_121853_;
        this.data = null;
    }

    public TileToClientPacket(BlockPos pos, CompoundTag data) {
        this.pos = pos;
        this.data = data;
    }

    public static void encode(TileToClientPacket message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.m_130079_(message.data);
    }

    public static TileToClientPacket decode(FriendlyByteBuf buf) {
        TileToClientPacket message = new TileToClientPacket();
        message.pos = buf.m_130135_();
        message.data = buf.m_130260_();
        return message;
    }

    public static class Handler {
        public static void onMessage(TileToClientPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                BlockEntity tile;
                Level world;
                Object object = world = FMLEnvironment.dist == Dist.CLIENT ? ClientUtils.getCurrentLevel() : null;
                if (world != null && world.m_46805_(message.pos) && (tile = world.m_7702_(message.pos)) != null && tile instanceof AbstractTilePM) {
                    ((AbstractTilePM)tile).onMessageFromServer(message.data == null ? new CompoundTag() : message.data);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

