/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class TileToServerPacket
implements IMessageToServer {
    protected BlockPos pos;
    protected CompoundTag data;

    public TileToServerPacket() {
        this.pos = BlockPos.f_121853_;
        this.data = null;
    }

    public TileToServerPacket(BlockPos pos, CompoundTag data) {
        this.pos = pos;
        this.data = data;
    }

    public static void encode(TileToServerPacket message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.m_130079_(message.data);
    }

    public static TileToServerPacket decode(FriendlyByteBuf buf) {
        TileToServerPacket message = new TileToServerPacket();
        message.pos = buf.m_130135_();
        message.data = buf.m_130260_();
        return message;
    }

    public static class Handler {
        public static void onMessage(TileToServerPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                BlockEntity tile;
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                Level world = sender.m_9236_();
                if (world != null && world.m_46805_(message.pos) && (tile = world.m_7702_(message.pos)) != null && tile instanceof AbstractTilePM) {
                    ((AbstractTilePM)tile).onMessageFromClient(message.data == null ? new CompoundTag() : message.data, sender);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

