/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.common.affinities.AffinityManager;
import com.verdantartifice.primalmagick.common.affinities.AffinityType;
import com.verdantartifice.primalmagick.common.affinities.IAffinity;
import com.verdantartifice.primalmagick.common.affinities.IAffinitySerializer;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class UpdateAffinitiesPacket
implements IMessageToClient {
    protected List<IAffinity> affinities;

    public UpdateAffinitiesPacket(Collection<IAffinity> affinities) {
        this.affinities = new ArrayList<IAffinity>(affinities);
    }

    public UpdateAffinitiesPacket(FriendlyByteBuf buf) {
        this.affinities = buf.m_236845_(UpdateAffinitiesPacket::fromNetwork);
    }

    public List<IAffinity> getAffinities() {
        return this.affinities;
    }

    public static void encode(UpdateAffinitiesPacket message, FriendlyByteBuf buf) {
        buf.m_236828_(message.affinities, UpdateAffinitiesPacket::toNetwork);
    }

    public static UpdateAffinitiesPacket decode(FriendlyByteBuf buf) {
        return new UpdateAffinitiesPacket(buf);
    }

    public static IAffinity fromNetwork(FriendlyByteBuf buf) {
        String typeStr = buf.m_130277_();
        AffinityType type = AffinityType.parse(typeStr);
        IAffinitySerializer<?> serializer = AffinityManager.getSerializer(type);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown affinity serializer " + typeStr);
        }
        return serializer.fromNetwork(buf);
    }

    public static <T extends IAffinity> void toNetwork(FriendlyByteBuf buf, T affinity) {
        buf.m_130070_(affinity.getType().m_7912_());
        affinity.getSerializer().toNetwork(buf, affinity);
    }

    public static class Handler {
        public static void onMessage(UpdateAffinitiesPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> AffinityManager.getOrCreateInstance().replaceAffinities(message.getAffinities()));
            ctx.get().setPacketHandled(true);
        }
    }
}

