/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import com.verdantartifice.primalmagick.common.runes.RuneEnchantmentDefinition;
import com.verdantartifice.primalmagick.common.runes.RuneEnchantmentDefinitionLoader;
import com.verdantartifice.primalmagick.common.runes.RuneManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class UpdateRuneEnchantmentsPacket
implements IMessageToClient {
    protected Map<ResourceLocation, RuneEnchantmentDefinition> definitions;

    public UpdateRuneEnchantmentsPacket(Map<ResourceLocation, RuneEnchantmentDefinition> definitions) {
        this.definitions = new HashMap<ResourceLocation, RuneEnchantmentDefinition>(definitions);
    }

    public UpdateRuneEnchantmentsPacket(FriendlyByteBuf buf) {
        this.definitions = new HashMap<ResourceLocation, RuneEnchantmentDefinition>();
        int mapSize = buf.m_130242_();
        for (int index = 0; index < mapSize; ++index) {
            ResourceLocation loc = buf.m_130281_();
            RuneEnchantmentDefinition def = RuneManager.DEFINITION_SERIALIZER.fromNetwork(buf);
            this.definitions.put(loc, def);
        }
    }

    public Map<ResourceLocation, RuneEnchantmentDefinition> getDefinitions() {
        return this.definitions;
    }

    public static void encode(UpdateRuneEnchantmentsPacket message, FriendlyByteBuf buf) {
        buf.m_130130_(message.definitions.size());
        for (Map.Entry<ResourceLocation, RuneEnchantmentDefinition> entry : message.definitions.entrySet()) {
            buf.m_130085_(entry.getKey());
            RuneManager.DEFINITION_SERIALIZER.toNetwork(buf, entry.getValue());
        }
    }

    public static UpdateRuneEnchantmentsPacket decode(FriendlyByteBuf buf) {
        return new UpdateRuneEnchantmentsPacket(buf);
    }

    public static class Handler {
        public static void onMessage(UpdateRuneEnchantmentsPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> RuneEnchantmentDefinitionLoader.createInstance().replaceRuneEnchantments(message.getDefinitions()));
            ctx.get().setPacketHandled(true);
        }
    }
}

