/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import com.verdantartifice.primalmagick.common.theorycrafting.ProjectTemplate;
import com.verdantartifice.primalmagick.common.theorycrafting.ProjectTemplateLoader;
import com.verdantartifice.primalmagick.common.theorycrafting.TheorycraftManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class UpdateTheorycraftingPacket
implements IMessageToClient {
    protected Map<ResourceLocation, ProjectTemplate> templates;

    public UpdateTheorycraftingPacket(Map<ResourceLocation, ProjectTemplate> templates) {
        this.templates = new HashMap<ResourceLocation, ProjectTemplate>(templates);
    }

    public UpdateTheorycraftingPacket(FriendlyByteBuf buf) {
        this.templates = new HashMap<ResourceLocation, ProjectTemplate>();
        int mapSize = buf.m_130242_();
        for (int index = 0; index < mapSize; ++index) {
            ResourceLocation loc = buf.m_130281_();
            ProjectTemplate template = TheorycraftManager.TEMPLATE_SERIALIZER.fromNetwork(buf);
            this.templates.put(loc, template);
        }
    }

    public Map<ResourceLocation, ProjectTemplate> getTemplates() {
        return this.templates;
    }

    public static void encode(UpdateTheorycraftingPacket message, FriendlyByteBuf buf) {
        buf.m_130130_(message.templates.size());
        for (Map.Entry<ResourceLocation, ProjectTemplate> entry : message.templates.entrySet()) {
            buf.m_130085_(entry.getKey());
            TheorycraftManager.TEMPLATE_SERIALIZER.toNetwork(buf, entry.getValue());
        }
    }

    public static UpdateTheorycraftingPacket decode(FriendlyByteBuf buf) {
        return new UpdateTheorycraftingPacket(buf);
    }

    public static class Handler {
        public static void onMessage(UpdateTheorycraftingPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> ProjectTemplateLoader.createInstance().replaceTemplates(message.getTemplates()));
            ctx.get().setPacketHandled(true);
        }
    }
}

