/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.fx;

import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PlayClientSoundPacket
implements IMessageToClient {
    protected String eventLoc;
    protected float volume;
    protected float pitch;

    public PlayClientSoundPacket() {
        this.eventLoc = "";
        this.volume = 0.0f;
        this.pitch = 0.0f;
    }

    public PlayClientSoundPacket(SoundEvent event, float volume, float pitch) {
        this.eventLoc = ForgeRegistries.SOUND_EVENTS.getKey((Object)event).toString();
        this.volume = volume;
        this.pitch = pitch;
    }

    public static void encode(PlayClientSoundPacket message, FriendlyByteBuf buf) {
        buf.m_130070_(message.eventLoc);
        buf.writeFloat(message.volume);
        buf.writeFloat(message.pitch);
    }

    public static PlayClientSoundPacket decode(FriendlyByteBuf buf) {
        PlayClientSoundPacket message = new PlayClientSoundPacket();
        message.eventLoc = buf.m_130277_();
        message.volume = buf.readFloat();
        message.pitch = buf.readFloat();
        return message;
    }

    public static class Handler {
        public static void onMessage(PlayClientSoundPacket message, Supplier<NetworkEvent.Context> ctx) {
            Player player = FMLEnvironment.dist == Dist.CLIENT ? ClientUtils.getCurrentPlayer() : null;
            ctx.get().enqueueWork(() -> {
                ResourceLocation eventLoc = ResourceLocation.m_135820_((String)message.eventLoc);
                if (eventLoc != null && ForgeRegistries.SOUND_EVENTS.containsKey(eventLoc)) {
                    player.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(eventLoc), message.volume, message.pitch);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

