/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.fx;

import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class PotionExplosionPacket
implements IMessageToClient {
    protected double x;
    protected double y;
    protected double z;
    protected int color;
    protected boolean isInstant;

    public PotionExplosionPacket() {
    }

    public PotionExplosionPacket(double x, double y, double z, int color, boolean isInstant) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.color = color;
        this.isInstant = isInstant;
    }

    public PotionExplosionPacket(Vec3 vec, int color, boolean isInstant) {
        this(vec.f_82479_, vec.f_82480_, vec.f_82481_, color, isInstant);
    }

    public static void encode(PotionExplosionPacket message, FriendlyByteBuf buf) {
        buf.writeDouble(message.x);
        buf.writeDouble(message.y);
        buf.writeDouble(message.z);
        buf.m_130130_(message.color);
        buf.writeBoolean(message.isInstant);
    }

    public static PotionExplosionPacket decode(FriendlyByteBuf buf) {
        PotionExplosionPacket message = new PotionExplosionPacket();
        message.x = buf.readDouble();
        message.y = buf.readDouble();
        message.z = buf.readDouble();
        message.color = buf.m_130242_();
        message.isInstant = buf.readBoolean();
        return message;
    }

    public static class Handler {
        public static void onMessage(PotionExplosionPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> FxDispatcher.INSTANCE.potionExplosion(message.x, message.y, message.z, message.color, message.isInstant));
            ctx.get().setPacketHandled(true);
        }
    }
}

