/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.fx;

import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class PropMarkerPacket
implements IMessageToClient {
    protected BlockPos pos;
    protected int lifetime;

    public PropMarkerPacket() {
    }

    public PropMarkerPacket(@Nonnull BlockPos pos) {
        this(pos, 6000);
    }

    public PropMarkerPacket(@Nonnull BlockPos pos, int lifetime) {
        this.pos = pos;
        this.lifetime = lifetime;
    }

    public static void encode(PropMarkerPacket message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.m_130130_(message.lifetime);
    }

    public static PropMarkerPacket decode(FriendlyByteBuf buf) {
        PropMarkerPacket message = new PropMarkerPacket();
        message.pos = buf.m_130135_();
        message.lifetime = buf.m_130242_();
        return message;
    }

    public static class Handler {
        public static void onMessage(PropMarkerPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Level world;
                Object object = world = FMLEnvironment.dist == Dist.CLIENT ? ClientUtils.getCurrentLevel() : null;
                if (world != null && world.m_46805_(message.pos)) {
                    FxDispatcher.INSTANCE.propMarker(message.pos, message.lifetime);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

