/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.fx;

import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SpellImpactPacket
implements IMessageToClient {
    protected double x;
    protected double y;
    protected double z;
    protected int radius;
    protected int color;

    public SpellImpactPacket() {
    }

    public SpellImpactPacket(double x, double y, double z, int radius, int color) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = radius;
        this.color = color;
    }

    public static void encode(SpellImpactPacket message, FriendlyByteBuf buf) {
        buf.writeDouble(message.x);
        buf.writeDouble(message.y);
        buf.writeDouble(message.z);
        buf.writeInt(message.radius);
        buf.writeInt(message.color);
    }

    public static SpellImpactPacket decode(FriendlyByteBuf buf) {
        SpellImpactPacket message = new SpellImpactPacket();
        message.x = buf.readDouble();
        message.y = buf.readDouble();
        message.z = buf.readDouble();
        message.radius = buf.readInt();
        message.color = buf.readInt();
        return message;
    }

    public static class Handler {
        public static void onMessage(SpellImpactPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> FxDispatcher.INSTANCE.spellImpact(message.x, message.y, message.z, message.radius, message.color));
            ctx.get().setPacketHandled(true);
        }
    }
}

