/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.fx;

import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class SpellTrailPacket
implements IMessageToClient {
    protected double x;
    protected double y;
    protected double z;
    protected int color;

    public SpellTrailPacket() {
    }

    public SpellTrailPacket(double x, double y, double z, int color) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.color = color;
    }

    public SpellTrailPacket(Vec3 pos, int color) {
        this(pos.f_82479_, pos.f_82480_, pos.f_82481_, color);
    }

    public static void encode(SpellTrailPacket message, FriendlyByteBuf buf) {
        buf.writeDouble(message.x);
        buf.writeDouble(message.y);
        buf.writeDouble(message.z);
        buf.writeInt(message.color);
    }

    public static SpellTrailPacket decode(FriendlyByteBuf buf) {
        SpellTrailPacket message = new SpellTrailPacket();
        message.x = buf.readDouble();
        message.y = buf.readDouble();
        message.z = buf.readDouble();
        message.color = buf.readInt();
        return message;
    }

    public static class Handler {
        public static void onMessage(SpellTrailPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> FxDispatcher.INSTANCE.spellTrail(message.x, message.y, message.z, message.color));
            ctx.get().setPacketHandled(true);
        }
    }
}

