/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.fx;

import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class TeleportArrivalPacket
implements IMessageToClient {
    protected double x;
    protected double y;
    protected double z;

    public TeleportArrivalPacket() {
    }

    public TeleportArrivalPacket(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void encode(TeleportArrivalPacket message, FriendlyByteBuf buf) {
        buf.writeDouble(message.x);
        buf.writeDouble(message.y);
        buf.writeDouble(message.z);
    }

    public static TeleportArrivalPacket decode(FriendlyByteBuf buf) {
        TeleportArrivalPacket message = new TeleportArrivalPacket();
        message.x = buf.readDouble();
        message.y = buf.readDouble();
        message.z = buf.readDouble();
        return message;
    }

    public static class Handler {
        public static void onMessage(TeleportArrivalPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> FxDispatcher.INSTANCE.teleportArrival(message.x, message.y, message.z));
            ctx.get().setPacketHandled(true);
        }
    }
}

