/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.fx;

import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class WandPoofPacket
implements IMessageToClient {
    protected double x;
    protected double y;
    protected double z;
    protected int color;
    protected boolean sound;
    protected byte face;

    public WandPoofPacket() {
    }

    public WandPoofPacket(double x, double y, double z, int color, boolean sound, @Nullable Direction facing) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.color = color;
        this.sound = sound;
        this.face = (byte)(facing == null ? -1 : (byte)facing.m_122411_());
    }

    public WandPoofPacket(@Nonnull BlockPos pos, int color, boolean sound, @Nullable Direction facing) {
        this((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, color, sound, facing);
    }

    public static void encode(WandPoofPacket message, FriendlyByteBuf buf) {
        buf.writeDouble(message.x);
        buf.writeDouble(message.y);
        buf.writeDouble(message.z);
        buf.m_130130_(message.color);
        buf.writeBoolean(message.sound);
        buf.writeByte((int)message.face);
    }

    public static WandPoofPacket decode(FriendlyByteBuf buf) {
        WandPoofPacket message = new WandPoofPacket();
        message.x = buf.readDouble();
        message.y = buf.readDouble();
        message.z = buf.readDouble();
        message.color = buf.m_130242_();
        message.sound = buf.readBoolean();
        message.face = buf.readByte();
        return message;
    }

    public static class Handler {
        public static void onMessage(WandPoofPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Direction side = null;
                if (message.face >= 0) {
                    side = Direction.m_122376_((int)message.face);
                }
                FxDispatcher.INSTANCE.wandPoof(message.x, message.y, message.z, message.color, message.sound, side);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

