/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.misc;

import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.books.BookType;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class OpenEnchantedBookScreenPacket
implements IMessageToClient {
    protected final ResourceKey<?> bookKey;

    public OpenEnchantedBookScreenPacket(Enchantment ench) {
        this.bookKey = (ResourceKey)ForgeRegistries.ENCHANTMENTS.getResourceKey((Object)ench).orElseThrow();
    }

    private OpenEnchantedBookScreenPacket(ResourceKey<?> bookKey) {
        this.bookKey = bookKey;
    }

    public static void encode(OpenEnchantedBookScreenPacket message, FriendlyByteBuf buf) {
        buf.m_236858_(message.bookKey);
    }

    public static OpenEnchantedBookScreenPacket decode(FriendlyByteBuf buf) {
        return new OpenEnchantedBookScreenPacket(buf.m_236801_(ForgeRegistries.Keys.ENCHANTMENTS));
    }

    public static class Handler {
        public static void onMessage(OpenEnchantedBookScreenPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (FMLEnvironment.dist == Dist.CLIENT) {
                    ClientUtils.openStaticBookScreen(message.bookKey, BookLanguagesPM.GALACTIC.getId(), 0, BookType.BOOK.getBackgroundTexture());
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

