/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.misc;

import com.google.common.base.Preconditions;
import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.books.BooksPM;
import com.verdantartifice.primalmagick.common.items.books.StaticBookItem;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class OpenStaticBookScreenPacket
implements IMessageToClient {
    protected final ResourceKey<?> bookKey;
    protected final ResourceLocation languageId;
    protected final int translatedComprehension;
    protected final ResourceLocation bgTexture;

    public OpenStaticBookScreenPacket(ItemStack bookStack, ResourceLocation bgTexture) {
        Preconditions.checkArgument((boolean)bookStack.m_204117_(ItemTagsPM.STATIC_BOOKS), (Object)"Packet item stack must be a static book or tablet");
        this.bookKey = (ResourceKey)BooksPM.BOOKS.get().getResourceKey((Object)StaticBookItem.getBookDefinition(bookStack)).orElseThrow();
        this.languageId = BookLanguagesPM.LANGUAGES.get().getKey((Object)StaticBookItem.getBookLanguage(bookStack));
        this.translatedComprehension = StaticBookItem.getTranslatedComprehension(bookStack).orElse(0);
        this.bgTexture = bgTexture;
    }

    private OpenStaticBookScreenPacket(ResourceKey<?> bookKey, ResourceLocation languageId, int translatedComprehension, ResourceLocation bgTexture) {
        this.bookKey = bookKey;
        this.languageId = languageId;
        this.translatedComprehension = translatedComprehension;
        this.bgTexture = bgTexture;
    }

    public static void encode(OpenStaticBookScreenPacket message, FriendlyByteBuf buf) {
        buf.m_236858_(message.bookKey);
        buf.m_130085_(message.languageId);
        buf.m_130130_(message.translatedComprehension);
        buf.m_130085_(message.bgTexture);
    }

    public static OpenStaticBookScreenPacket decode(FriendlyByteBuf buf) {
        return new OpenStaticBookScreenPacket(buf.m_236801_(BooksPM.BOOKS.get().getRegistryKey()), buf.m_130281_(), buf.m_130242_(), buf.m_130281_());
    }

    public static class Handler {
        public static void onMessage(OpenStaticBookScreenPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (FMLEnvironment.dist == Dist.CLIENT) {
                    ClientUtils.openStaticBookScreen(message.bookKey, message.languageId, message.translatedComprehension, message.bgTexture);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

