/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.misc;

import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScanEntityPacket
implements IMessageToServer {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected EntityType<?> type;

    public ScanEntityPacket() {
        this.type = null;
    }

    public ScanEntityPacket(EntityType<?> type) {
        this.type = type;
    }

    public static void encode(ScanEntityPacket message, FriendlyByteBuf buf) {
        buf.m_130070_(ForgeRegistries.ENTITY_TYPES.getKey(message.type).toString());
    }

    public static ScanEntityPacket decode(FriendlyByteBuf buf) {
        ScanEntityPacket message = new ScanEntityPacket();
        message.type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(buf.m_130277_()));
        return message;
    }

    public static class Handler {
        public static void onMessage(ScanEntityPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (message.type != null) {
                    ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                    ((CompletableFuture)ResearchManager.isScannedAsync(message.type, (Player)player).thenAccept(isScanned -> {
                        if (isScanned.booleanValue()) {
                            player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.scan.repeat").m_130940_(ChatFormatting.RED), true);
                        } else if (ResearchManager.setScanned(message.type, player)) {
                            player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.scan.success").m_130940_(ChatFormatting.GREEN), true);
                        } else {
                            player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.scan.fail").m_130940_(ChatFormatting.RED), true);
                        }
                    })).exceptionally(e -> {
                        LOGGER.error("Failed to scan entity type " + message.type.toString(), e);
                        return null;
                    });
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

