/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.misc;

import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScanItemPacket
implements IMessageToServer {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected ItemStack stack;

    public ScanItemPacket() {
        this.stack = ItemStack.f_41583_;
    }

    public ScanItemPacket(ItemStack stack) {
        this.stack = stack;
    }

    public static void encode(ScanItemPacket message, FriendlyByteBuf buf) {
        buf.m_130055_(message.stack);
    }

    public static ScanItemPacket decode(FriendlyByteBuf buf) {
        ScanItemPacket message = new ScanItemPacket();
        message.stack = buf.m_130267_();
        return message;
    }

    public static class Handler {
        public static void onMessage(ScanItemPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (message.stack != null && !message.stack.m_41619_()) {
                    ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                    ((CompletableFuture)ResearchManager.isScannedAsync(message.stack, (Player)player).thenAccept(isScanned -> {
                        if (isScanned.booleanValue()) {
                            player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.scan.repeat").m_130940_(ChatFormatting.RED), true);
                        } else if (ResearchManager.setScanned(message.stack, player)) {
                            player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.scan.success").m_130940_(ChatFormatting.GREEN), true);
                        } else {
                            player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.scan.fail").m_130940_(ChatFormatting.RED), true);
                        }
                    })).exceptionally(e -> {
                        LOGGER.error("Failed to scan item stack " + message.stack.toString(), e);
                        return null;
                    });
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

