/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.misc;

import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.util.InventoryUtils;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScanPositionPacket
implements IMessageToServer {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected BlockPos pos;

    public ScanPositionPacket() {
        this.pos = BlockPos.f_121853_;
    }

    public ScanPositionPacket(@Nonnull BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(ScanPositionPacket message, FriendlyByteBuf buf) {
        buf.writeLong(message.pos.m_121878_());
    }

    public static ScanPositionPacket decode(FriendlyByteBuf buf) {
        ScanPositionPacket message = new ScanPositionPacket();
        message.pos = BlockPos.m_122022_((long)buf.readLong());
        return message;
    }

    public static class Handler {
        public static void onMessage(ScanPositionPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                Level world = player.m_20193_();
                if (message.pos != null && world.m_46749_(message.pos)) {
                    PrimalMagickCapabilities.getKnowledge((Player)player).ifPresent(knowledge -> {
                        ArrayList<CompletionStage> foundFutures = new ArrayList<CompletionStage>();
                        ItemStack posStack = new ItemStack((ItemLike)world.m_8055_(message.pos).m_60734_());
                        foundFutures.add(CompletableFuture.completedFuture(posStack).thenCombine(ResearchManager.isScannedAsync(posStack, (Player)player), (stack, isScanned) -> isScanned == false && ResearchManager.setScanned(stack, player, false)));
                        IItemHandler handler = InventoryUtils.getItemHandler(world, message.pos, Direction.UP);
                        if (handler != null) {
                            int scanCount = 0;
                            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                                ItemStack chestStack = handler.getStackInSlot(slot);
                                if (chestStack == null || chestStack.m_41619_()) continue;
                                if (scanCount >= 108) {
                                    player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.scan.toobig").m_130940_(ChatFormatting.RED), true);
                                    break;
                                }
                                foundFutures.add(CompletableFuture.completedFuture(chestStack).thenCombine(ResearchManager.isScannedAsync(chestStack, (Player)player), (stack, isScanned) -> isScanned == false && ResearchManager.setScanned(stack, player, false)));
                                ++scanCount;
                            }
                        }
                        ((CompletableFuture)Util.m_137567_(foundFutures).thenAccept(foundList -> {
                            if (foundList.stream().mapToInt(found -> found != false ? 1 : 0).sum() > 0) {
                                player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.scan.success").m_130940_(ChatFormatting.GREEN), true);
                                knowledge.sync(player);
                            } else {
                                player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.scan.repeat").m_130940_(ChatFormatting.RED), true);
                            }
                        })).exceptionally(e -> {
                            LOGGER.error("Failed to scan block at position " + message.pos, e);
                            return null;
                        });
                    });
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

