/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.misc;

import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.tiles.devices.EssenceCaskTileEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class WithdrawCaskEssencePacket
implements IMessageToServer {
    protected EssenceType essenceType;
    protected Source essenceSource;
    protected int amount;
    protected BlockPos caskPos;

    public WithdrawCaskEssencePacket() {
        this.essenceType = null;
        this.essenceSource = null;
        this.amount = -1;
        this.caskPos = BlockPos.f_121853_;
    }

    public WithdrawCaskEssencePacket(EssenceType type, Source source, int amount, BlockPos pos) {
        this.essenceType = type;
        this.essenceSource = source;
        this.amount = amount;
        this.caskPos = pos;
    }

    public static void encode(WithdrawCaskEssencePacket message, FriendlyByteBuf buf) {
        buf.m_130070_(message.essenceType.toString());
        buf.m_130070_(message.essenceSource.getTag());
        buf.m_130130_(message.amount);
        buf.writeLong(message.caskPos.m_121878_());
    }

    public static WithdrawCaskEssencePacket decode(FriendlyByteBuf buf) {
        WithdrawCaskEssencePacket message = new WithdrawCaskEssencePacket();
        message.essenceType = EssenceType.valueOf(buf.m_130277_());
        message.essenceSource = Source.getSource(buf.m_130277_());
        message.amount = buf.m_130242_();
        message.caskPos = BlockPos.m_122022_((long)buf.readLong());
        return message;
    }

    public static class Handler {
        public static void onMessage(WithdrawCaskEssencePacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                EssenceCaskTileEntity caskTile;
                int curCount;
                int toRemove;
                BlockEntity tile;
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                Level level = player.m_20193_();
                if (message.caskPos != null && level.m_46749_(message.caskPos) && (tile = level.m_7702_(message.caskPos)) instanceof EssenceCaskTileEntity && (toRemove = Math.min(message.amount, curCount = (caskTile = (EssenceCaskTileEntity)tile).getEssenceCount(message.essenceType, message.essenceSource))) > 0) {
                    int newCount = Math.max(0, curCount - toRemove);
                    caskTile.setEssenceCount(message.essenceType, message.essenceSource, newCount);
                    ItemStack stack = EssenceItem.getEssence(message.essenceType, message.essenceSource, toRemove);
                    if (!player.m_150109_().m_36054_(stack)) {
                        player.m_36176_(stack, false);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

