/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.recipe_book;

import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBookType;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ChangeArcaneRecipeBookSettingsPacket
implements IMessageToServer {
    protected ArcaneRecipeBookType type;
    protected boolean open;
    protected boolean filtering;

    public ChangeArcaneRecipeBookSettingsPacket() {
        this.type = null;
        this.open = false;
        this.filtering = false;
    }

    public ChangeArcaneRecipeBookSettingsPacket(ArcaneRecipeBookType type, boolean open, boolean filtering) {
        this.type = type;
        this.open = open;
        this.filtering = filtering;
    }

    public static void encode(ChangeArcaneRecipeBookSettingsPacket message, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)message.type);
        buf.writeBoolean(message.open);
        buf.writeBoolean(message.filtering);
    }

    public static ChangeArcaneRecipeBookSettingsPacket decode(FriendlyByteBuf buf) {
        ChangeArcaneRecipeBookSettingsPacket message = new ChangeArcaneRecipeBookSettingsPacket();
        message.type = (ArcaneRecipeBookType)buf.m_130066_(ArcaneRecipeBookType.class);
        message.open = buf.readBoolean();
        message.filtering = buf.readBoolean();
        return message;
    }

    public static class Handler {
        public static void onMessage(ChangeArcaneRecipeBookSettingsPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                PrimalMagickCapabilities.getArcaneRecipeBook((Player)player).ifPresent(recipeBook -> recipeBook.get().setBookSettings(message.type, message.open, message.filtering));
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

