/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.recipe_book;

import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class PlaceGhostArcaneRecipePacket
implements IMessageToClient {
    protected int containerId;
    protected ResourceLocation recipeId;

    public PlaceGhostArcaneRecipePacket() {
        this.containerId = -1;
        this.recipeId = null;
    }

    public PlaceGhostArcaneRecipePacket(int containerId, Recipe<?> recipe) {
        this.containerId = containerId;
        this.recipeId = recipe.m_6423_();
    }

    public static void encode(PlaceGhostArcaneRecipePacket message, FriendlyByteBuf buf) {
        buf.writeByte(message.containerId);
        buf.m_130085_(message.recipeId);
    }

    public static PlaceGhostArcaneRecipePacket decode(FriendlyByteBuf buf) {
        PlaceGhostArcaneRecipePacket message = new PlaceGhostArcaneRecipePacket();
        message.containerId = buf.readByte();
        message.recipeId = buf.m_130281_();
        return message;
    }

    public static class Handler {
        public static void onMessage(PlaceGhostArcaneRecipePacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (FMLEnvironment.dist == Dist.CLIENT) {
                    ClientUtils.handlePlaceGhostRecipe(message.containerId, message.recipeId);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

