/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.spellcrafting;

import com.verdantartifice.primalmagick.common.menus.SpellcraftingAltarMenu;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.spells.SpellComponent;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SetSpellComponentPropertyPacket
implements IMessageToServer {
    private static final Logger LOGGER = LogManager.getLogger();
    protected int windowId;
    protected SpellComponent attr;
    protected String name;
    protected int value;

    public SetSpellComponentPropertyPacket() {
        this.windowId = -1;
        this.attr = null;
        this.name = "";
        this.value = -1;
    }

    public SetSpellComponentPropertyPacket(int windowId, SpellComponent attr, String name, int value) {
        this.windowId = windowId;
        this.attr = attr;
        this.name = name;
        this.value = value;
    }

    public static void encode(SetSpellComponentPropertyPacket message, FriendlyByteBuf buf) {
        buf.writeInt(message.windowId);
        buf.m_130070_(message.attr.name());
        buf.m_130070_(message.name);
        buf.writeInt(message.value);
    }

    public static SetSpellComponentPropertyPacket decode(FriendlyByteBuf buf) {
        SetSpellComponentPropertyPacket message = new SetSpellComponentPropertyPacket();
        message.windowId = buf.readInt();
        String attrStr = buf.m_130277_();
        try {
            message.attr = SpellComponent.valueOf(attrStr);
        }
        catch (Exception e) {
            LOGGER.warn("Received SetSpellComponentPropertyPacket with unexpected attr value {}", (Object)attrStr);
            message.attr = null;
        }
        message.name = buf.m_130277_();
        message.value = buf.readInt();
        return message;
    }

    public static class Handler {
        public static void onMessage(SetSpellComponentPropertyPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                AbstractContainerMenu patt2693$temp;
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player.f_36096_ != null && player.f_36096_.f_38840_ == message.windowId && (patt2693$temp = player.f_36096_) instanceof SpellcraftingAltarMenu) {
                    SpellcraftingAltarMenu altarMenu = (SpellcraftingAltarMenu)patt2693$temp;
                    altarMenu.setSpellPropertyValue(message.attr, message.name, message.value);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

