/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.spellcrafting;

import com.verdantartifice.primalmagick.common.menus.SpellcraftingAltarMenu;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.spells.SpellComponent;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SetSpellComponentTypeIndexPacket
implements IMessageToServer {
    private static final Logger LOGGER = LogManager.getLogger();
    protected int windowId;
    protected SpellComponent attr;
    protected int index;

    public SetSpellComponentTypeIndexPacket() {
        this.windowId = -1;
        this.attr = null;
        this.index = -1;
    }

    public SetSpellComponentTypeIndexPacket(int windowId, SpellComponent attr, int index) {
        this.windowId = windowId;
        this.attr = attr;
        this.index = index;
    }

    public static void encode(SetSpellComponentTypeIndexPacket message, FriendlyByteBuf buf) {
        buf.writeInt(message.windowId);
        buf.m_130070_(message.attr.name());
        buf.writeInt(message.index);
    }

    public static SetSpellComponentTypeIndexPacket decode(FriendlyByteBuf buf) {
        SetSpellComponentTypeIndexPacket message = new SetSpellComponentTypeIndexPacket();
        message.windowId = buf.readInt();
        String attrStr = buf.m_130277_();
        try {
            message.attr = SpellComponent.valueOf(attrStr);
        }
        catch (Exception e) {
            LOGGER.warn("Received SetSpellAttributeTypeIndexPacket with unexpected attr value {}", (Object)attrStr);
            message.attr = null;
        }
        message.index = buf.readInt();
        return message;
    }

    public static class Handler {
        public static void onMessage(SetSpellComponentTypeIndexPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                AbstractContainerMenu patt2538$temp;
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player.f_36096_ != null && player.f_36096_.f_38840_ == message.windowId && (patt2538$temp = player.f_36096_) instanceof SpellcraftingAltarMenu) {
                    SpellcraftingAltarMenu altarMenu = (SpellcraftingAltarMenu)patt2538$temp;
                    switch (message.attr) {
                        case VEHICLE: {
                            altarMenu.setSpellVehicleTypeIndex(message.index);
                            break;
                        }
                        case PAYLOAD: {
                            altarMenu.setSpellPayloadTypeIndex(message.index);
                            break;
                        }
                        case PRIMARY_MOD: {
                            altarMenu.setSpellPrimaryModTypeIndex(message.index);
                            break;
                        }
                        case SECONDARY_MOD: {
                            altarMenu.setSpellSecondaryModTypeIndex(message.index);
                            break;
                        }
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

