/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.theorycrafting;

import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.menus.ResearchTableMenu;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.network.packets.fx.PlayClientSoundPacket;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.theorycrafting.Project;
import com.verdantartifice.primalmagick.common.theorycrafting.TheorycraftManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class CompleteProjectPacket
implements IMessageToServer {
    protected int windowId;

    public CompleteProjectPacket() {
        this.windowId = -1;
    }

    public CompleteProjectPacket(int windowId) {
        this.windowId = windowId;
    }

    public static void encode(CompleteProjectPacket message, FriendlyByteBuf buf) {
        buf.writeInt(message.windowId);
    }

    public static CompleteProjectPacket decode(FriendlyByteBuf buf) {
        CompleteProjectPacket message = new CompleteProjectPacket();
        message.windowId = buf.readInt();
        return message;
    }

    public static class Handler {
        public static void onMessage(CompleteProjectPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                PrimalMagickCapabilities.getKnowledge((Player)player).ifPresent(knowledge -> {
                    AbstractContainerMenu patt2541$temp;
                    if (player.f_36096_ != null && player.f_36096_.f_38840_ == message.windowId && (patt2541$temp = player.f_36096_) instanceof ResearchTableMenu) {
                        ResearchTableMenu researchMenu = (ResearchTableMenu)patt2541$temp;
                        researchMenu.consumeWritingImplements();
                        researchMenu.getContainerLevelAccess().m_39292_((world, blockPos) -> {
                            Project project = knowledge.getActiveResearchProject();
                            RandomSource rand = player.m_217043_();
                            if (project != null && project.isSatisfied((Player)player, TheorycraftManager.getSurroundings(world, blockPos)) && project.consumeSelectedMaterials((Player)player)) {
                                if (rand.m_188500_() < project.getSuccessChance()) {
                                    ResearchManager.addKnowledge((Player)player, KnowledgeType.THEORY, project.getTheoryPointReward());
                                    project.getOtherRewards().forEach(reward -> reward.grant(player));
                                    StatsManager.incrementValue((Player)player, StatsPM.RESEARCH_PROJECTS_COMPLETED);
                                    PacketHandler.sendToPlayer(new PlayClientSoundPacket((SoundEvent)SoundsPM.WRITING.get(), 1.0f, 1.0f + (float)rand.m_188583_() * 0.05f), player);
                                } else {
                                    PacketHandler.sendToPlayer(new PlayClientSoundPacket(SoundEvents.f_11983_, 1.0f, 1.0f + (float)rand.m_188583_() * 0.05f), player);
                                }
                            }
                            knowledge.setActiveResearchProject(TheorycraftManager.createRandomProject(player, blockPos));
                        });
                        knowledge.sync(player);
                    }
                });
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

