/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.theorycrafting;

import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.theorycrafting.Project;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SetProjectMaterialSelectionPacket
implements IMessageToServer {
    protected int index;
    protected boolean selected;

    public SetProjectMaterialSelectionPacket() {
        this.index = -1;
        this.selected = false;
    }

    public SetProjectMaterialSelectionPacket(int index, boolean selected) {
        this.index = index;
        this.selected = selected;
    }

    public static void encode(SetProjectMaterialSelectionPacket message, FriendlyByteBuf buf) {
        buf.writeInt(message.index);
        buf.writeBoolean(message.selected);
    }

    public static SetProjectMaterialSelectionPacket decode(FriendlyByteBuf buf) {
        SetProjectMaterialSelectionPacket message = new SetProjectMaterialSelectionPacket();
        message.index = buf.readInt();
        message.selected = buf.readBoolean();
        return message;
    }

    public static class Handler {
        public static void onMessage(SetProjectMaterialSelectionPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                PrimalMagickCapabilities.getKnowledge((Player)player).ifPresent(knowledge -> {
                    Project project = knowledge.getActiveResearchProject();
                    if (project != null && message.index >= 0 && message.index < project.getMaterials().size()) {
                        project.getMaterials().get(message.index).setSelected(message.selected);
                    }
                });
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

