/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.theorycrafting;

import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.menus.ResearchTableMenu;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.theorycrafting.TheorycraftManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class StartProjectPacket
implements IMessageToServer {
    protected int windowId;

    public StartProjectPacket() {
        this.windowId = -1;
    }

    public StartProjectPacket(int windowId) {
        this.windowId = windowId;
    }

    public static void encode(StartProjectPacket message, FriendlyByteBuf buf) {
        buf.writeInt(message.windowId);
    }

    public static StartProjectPacket decode(FriendlyByteBuf buf) {
        StartProjectPacket message = new StartProjectPacket();
        message.windowId = buf.readInt();
        return message;
    }

    public static class Handler {
        public static void onMessage(StartProjectPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                PrimalMagickCapabilities.getKnowledge((Player)player).ifPresent(knowledge -> {
                    if (player.f_36096_ != null && player.f_36096_.f_38840_ == message.windowId && player.f_36096_ instanceof ResearchTableMenu) {
                        ((ResearchTableMenu)player.f_36096_).getContainerLevelAccess().m_39292_((world, blockPos) -> knowledge.setActiveResearchProject(TheorycraftManager.createRandomProject(player, blockPos)));
                        knowledge.sync(player);
                    }
                });
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

