/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.mojang.serialization.Codec;
import com.verdantartifice.primalmagick.common.research.IResearchKey;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;

public class CompoundResearchKey
implements IResearchKey {
    public static final CompoundResearchKey EMPTY = new CompoundResearchKey(true);
    public static final Codec<CompoundResearchKey> CODEC = Codec.STRING.xmap(CompoundResearchKey::parse, CompoundResearchKey::toString);
    protected final List<SimpleResearchKey> keys;
    protected final boolean requireAll;

    protected CompoundResearchKey(boolean requireAll) {
        this.requireAll = requireAll;
        this.keys = ImmutableList.of();
    }

    protected CompoundResearchKey(boolean requireAll, @Nonnull SimpleResearchKey key) {
        this.requireAll = requireAll;
        this.keys = ImmutableList.of((Object)key);
    }

    protected CompoundResearchKey(boolean requireAll, SimpleResearchKey ... keys) {
        this.requireAll = requireAll;
        this.keys = ImmutableList.builder().add((Object[])keys).build();
    }

    protected CompoundResearchKey(boolean requireAll, @Nonnull List<SimpleResearchKey> keys) {
        this.requireAll = requireAll;
        this.keys = ImmutableList.builder().addAll(keys).build();
    }

    public static CompoundResearchKey parse(String keyStr) {
        if (keyStr == null) {
            throw new IllegalArgumentException("Key string may not be null");
        }
        if (keyStr.isEmpty()) {
            return EMPTY;
        }
        if (keyStr.contains("&&")) {
            if (keyStr.contains("||")) {
                throw new IllegalArgumentException("Research key may contain && or || but not both");
            }
            return CompoundResearchKey.from(true, CompoundResearchKey.parseKeys(keyStr, "&&"));
        }
        if (keyStr.contains("||")) {
            return CompoundResearchKey.from(false, CompoundResearchKey.parseKeys(keyStr, "||"));
        }
        return CompoundResearchKey.from(SimpleResearchKey.parse(keyStr));
    }

    protected static List<SimpleResearchKey> parseKeys(String keyStr, String glue) {
        return Arrays.asList(keyStr.split(glue)).stream().filter(Objects::nonNull).map(SimpleResearchKey::parse).toList();
    }

    public static Builder builder(boolean requireAll) {
        return new Builder(requireAll);
    }

    public static CompoundResearchKey parse(@Nullable JsonArray jsonArray) throws Exception {
        if (jsonArray == null) {
            throw new IllegalArgumentException("JSON data may not be null");
        }
        ImmutableList.Builder keyBuilder = ImmutableList.builder();
        jsonArray.asList().stream().map(e -> SimpleResearchKey.parse(e.getAsString())).forEach(arg_0 -> ((ImmutableList.Builder)keyBuilder).add(arg_0));
        return new CompoundResearchKey(true, (List<SimpleResearchKey>)keyBuilder.build());
    }

    public static CompoundResearchKey from(@Nullable SimpleResearchKey simpleKey) {
        if (simpleKey == null) {
            throw new IllegalArgumentException("Inner key may not be null");
        }
        return new CompoundResearchKey(true, simpleKey);
    }

    public static Optional<CompoundResearchKey> from(@Nonnull Optional<SimpleResearchKey> simpleKeyOpt) {
        return simpleKeyOpt.isPresent() ? Optional.of(new CompoundResearchKey(true, simpleKeyOpt.get())) : Optional.empty();
    }

    public static CompoundResearchKey from(boolean requireAll, SimpleResearchKey ... simpleKeys) {
        return new CompoundResearchKey(requireAll, Arrays.stream(simpleKeys).filter(Objects::nonNull).toList());
    }

    public static CompoundResearchKey from(boolean requireAll, List<SimpleResearchKey> simpleKeys) {
        return new CompoundResearchKey(requireAll, simpleKeys.stream().filter(Objects::nonNull).toList());
    }

    public static CompoundResearchKey from(boolean requireAll, String ... keyStrs) {
        return new CompoundResearchKey(requireAll, Arrays.stream(keyStrs).filter(Objects::nonNull).map(SimpleResearchKey::parse).toList());
    }

    @Nonnull
    public CompoundResearchKey copy() {
        return new CompoundResearchKey(this.requireAll, this.keys.stream().map(SimpleResearchKey::copy).toList());
    }

    @Nonnull
    public List<SimpleResearchKey> getKeys() {
        return this.keys;
    }

    public boolean getRequireAll() {
        return this.requireAll;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty() || this.keys.stream().allMatch(SimpleResearchKey::isEmpty);
    }

    @Override
    public boolean isKnownBy(@Nullable Player player) {
        if (this.equals(EMPTY)) {
            return true;
        }
        if (this.requireAll) {
            return this.keys.stream().allMatch(simpleKey -> simpleKey.isKnownBy(player));
        }
        return this.keys.stream().anyMatch(simpleKey -> simpleKey.isKnownBy(player));
    }

    @Override
    public boolean isKnownByStrict(@Nullable Player player) {
        if (this.equals(EMPTY)) {
            return true;
        }
        if (this.requireAll) {
            return this.keys.stream().allMatch(simpleKey -> simpleKey.isKnownByStrict(player));
        }
        return this.keys.stream().anyMatch(simpleKey -> simpleKey.isKnownByStrict(player));
    }

    public boolean contains(@Nullable SimpleResearchKey simpleKey) {
        if (simpleKey == null) {
            return false;
        }
        return this.keys.contains(simpleKey);
    }

    public boolean containsStripped(@Nullable SimpleResearchKey simpleKey) {
        if (simpleKey == null) {
            return false;
        }
        return this.keys.stream().map(k -> k.stripStage()).toList().contains(simpleKey.stripStage());
    }

    public String toString() {
        return String.join((CharSequence)(this.requireAll ? "&&" : "||"), this.keys.stream().map(k -> k.toString()).toList());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keys == null ? 0 : this.keys.hashCode());
        result = 31 * result + (this.requireAll ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompoundResearchKey other = (CompoundResearchKey)obj;
        if (this.keys == null ? other.keys != null : !this.keys.equals(other.keys)) {
            return false;
        }
        return this.requireAll == other.requireAll;
    }

    public static class Builder {
        private final boolean requireAll;
        private final List<SimpleResearchKey> simpleKeys = new ArrayList<SimpleResearchKey>();

        protected Builder(boolean requireAll) {
            this.requireAll = requireAll;
        }

        public Builder add(SimpleResearchKey key) {
            this.simpleKeys.add(key);
            return this;
        }

        public Builder add(Optional<SimpleResearchKey> keyOpt) {
            return this.add(keyOpt.orElseThrow());
        }

        public CompoundResearchKey build() {
            return new CompoundResearchKey(this.requireAll, this.simpleKeys);
        }
    }
}

