/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research;

import com.verdantartifice.primalmagick.PrimalMagick;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public enum KnowledgeType implements StringRepresentable
{
    OBSERVATION("observation", 16, PrimalMagick.resource("textures/research/knowledge_observation.png")),
    THEORY("theory", 32, PrimalMagick.resource("textures/research/knowledge_theory.png"));

    private final String name;
    private final short progression;
    private final ResourceLocation iconLocation;

    private KnowledgeType(@Nonnull String name, int progression, ResourceLocation iconLocation) {
        this.name = name;
        this.progression = (short)progression;
        this.iconLocation = iconLocation;
    }

    public int getProgression() {
        return this.progression;
    }

    @Nonnull
    public ResourceLocation getIconLocation() {
        return this.iconLocation;
    }

    @Nonnull
    public String getNameTranslationKey() {
        return String.join((CharSequence)".", "knowledge_type", "primalmagick", this.m_7912_());
    }

    public String m_7912_() {
        return this.name;
    }

    @Nullable
    public static KnowledgeType fromName(@Nullable String name) {
        for (KnowledgeType knowledgeType : KnowledgeType.values()) {
            if (!knowledgeType.m_7912_().equals(name)) continue;
            return knowledgeType;
        }
        return null;
    }
}

