/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.util.JsonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ResearchAddendum {
    protected ResearchEntry researchEntry;
    protected String textTranslationKey;
    protected List<ResourceLocation> recipes = new ArrayList<ResourceLocation>();
    protected List<SimpleResearchKey> siblings = new ArrayList<SimpleResearchKey>();
    protected CompoundResearchKey requiredResearch;
    protected SourceList attunements = SourceList.EMPTY;

    protected ResearchAddendum(@Nonnull ResearchEntry entry, @Nonnull String textTranslationKey) {
        this.researchEntry = entry;
        this.textTranslationKey = textTranslationKey;
    }

    @Nullable
    public static ResearchAddendum create(@Nonnull ResearchEntry entry, @Nullable String textTranslationKey) {
        return textTranslationKey == null ? null : new ResearchAddendum(entry, textTranslationKey);
    }

    @Nonnull
    public static ResearchAddendum parse(@Nonnull ResearchEntry entry, @Nonnull JsonObject obj) throws Exception {
        ResearchAddendum addendum = ResearchAddendum.create(entry, obj.getAsJsonPrimitive("text").getAsString());
        if (addendum == null) {
            throw new JsonParseException("Illegal addendum text in research JSON");
        }
        if (obj.has("recipes")) {
            addendum.recipes = JsonUtils.toResourceLocations(obj.get("recipes").getAsJsonArray());
        }
        if (obj.has("siblings")) {
            addendum.siblings = JsonUtils.toSimpleResearchKeys(obj.get("siblings").getAsJsonArray());
        }
        if (obj.has("required_research")) {
            addendum.requiredResearch = CompoundResearchKey.parse(obj.get("required_research").getAsJsonArray());
        }
        if (obj.has("attunements")) {
            addendum.attunements = JsonUtils.toSourceList(obj.get("attunements").getAsJsonObject());
        }
        return addendum;
    }

    @Nonnull
    public static ResearchAddendum fromNetwork(FriendlyByteBuf buf, ResearchEntry entry) {
        ResearchAddendum addendum = ResearchAddendum.create(entry, buf.m_130277_());
        int recipeSize = buf.m_130242_();
        for (int index = 0; index < recipeSize; ++index) {
            addendum.recipes.add(new ResourceLocation(buf.m_130277_()));
        }
        int siblingSize = buf.m_130242_();
        for (int index = 0; index < siblingSize; ++index) {
            addendum.siblings.add(SimpleResearchKey.parse(buf.m_130277_()));
        }
        addendum.requiredResearch = CompoundResearchKey.parse(buf.m_130277_());
        addendum.attunements = SourceList.fromNetwork(buf);
        return addendum;
    }

    public static void toNetwork(FriendlyByteBuf buf, ResearchAddendum addendum) {
        buf.m_130070_(addendum.textTranslationKey);
        buf.m_130130_(addendum.recipes.size());
        for (ResourceLocation recipe : addendum.recipes) {
            buf.m_130070_(recipe.toString());
        }
        buf.m_130130_(addendum.siblings.size());
        for (SimpleResearchKey key : addendum.siblings) {
            buf.m_130070_(key.toString());
        }
        buf.m_130070_(addendum.requiredResearch == null ? "" : addendum.requiredResearch.toString());
        SourceList.toNetwork(buf, addendum.attunements);
    }

    @Nonnull
    public ResearchEntry getResearchEntry() {
        return this.researchEntry;
    }

    @Nonnull
    public String getTextTranslationKey() {
        return this.textTranslationKey;
    }

    @Nonnull
    public List<ResourceLocation> getRecipes() {
        return Collections.unmodifiableList(this.recipes);
    }

    @Nonnull
    public List<SimpleResearchKey> getSiblings() {
        return Collections.unmodifiableList(this.siblings);
    }

    @Nullable
    public CompoundResearchKey getRequiredResearch() {
        return this.requiredResearch;
    }

    @Nonnull
    public SourceList getAttunements() {
        return this.attunements;
    }
}

