/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research;

import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.stats.Stat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class ResearchDiscipline {
    protected final String key;
    protected final CompoundResearchKey unlockResearchKey;
    protected final ResourceLocation iconLocation;
    protected final Stat craftingStat;
    protected final Map<SimpleResearchKey, ResearchEntry> entries = new HashMap<SimpleResearchKey, ResearchEntry>();
    protected List<ResearchEntry> finales = null;

    protected ResearchDiscipline(@Nonnull String key, @Nullable CompoundResearchKey unlockResearchKey, @Nonnull ResourceLocation icon, @Nullable Stat craftingStat) {
        this.key = key;
        this.unlockResearchKey = unlockResearchKey;
        this.iconLocation = icon;
        this.craftingStat = craftingStat;
    }

    @Nullable
    public static ResearchDiscipline create(@Nullable String key, @Nullable CompoundResearchKey unlockResearchKey, @Nullable ResourceLocation icon, @Nullable Stat craftingStat) {
        return key == null || icon == null ? null : new ResearchDiscipline(key, unlockResearchKey, icon, craftingStat);
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getNameTranslationKey() {
        return String.join((CharSequence)".", "research_discipline", "primalmagick", this.key);
    }

    @Nullable
    public CompoundResearchKey getUnlockResearchKey() {
        return this.unlockResearchKey;
    }

    @Nonnull
    public ResourceLocation getIconLocation() {
        return this.iconLocation;
    }

    @Nullable
    public Stat getCraftingStat() {
        return this.craftingStat;
    }

    @Nullable
    public ResearchEntry getEntry(SimpleResearchKey key) {
        return this.entries.get(key);
    }

    @Nonnull
    public Collection<ResearchEntry> getEntries() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    public boolean addEntry(@Nullable ResearchEntry entry) {
        if (entry == null || this.entries.containsKey(entry.getKey())) {
            return false;
        }
        this.entries.put(entry.getKey(), entry);
        return true;
    }

    void clearEntries() {
        this.entries.clear();
    }

    @Nonnull
    public List<ResearchEntry> getFinaleEntries() {
        if (this.finales == null) {
            this.finales = ResearchEntries.getAllEntries().stream().filter(e -> e.isFinaleFor(this.key)).collect(Collectors.toList());
        }
        return this.finales;
    }
}

