/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.stats.Stat;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class ResearchDisciplines {
    protected static final Map<String, ResearchDiscipline> DISCIPLINES = new HashMap<String, ResearchDiscipline>();
    protected static final List<ResearchDiscipline> DISCIPLINES_SORTED = new ArrayList<ResearchDiscipline>();
    public static final ResearchDiscipline BASICS = ResearchDisciplines.registerDiscipline("BASICS", null, PrimalMagick.resource("textures/item/grimoire.png"), null);
    public static final ResearchDiscipline MANAWEAVING = ResearchDisciplines.registerDiscipline("MANAWEAVING", ((ResearchName)ResearchNames.UNLOCK_MANAWEAVING.get()).compoundKey(), PrimalMagick.resource("textures/research/discipline_manaweaving.png"), StatsPM.CRAFTED_MANAWEAVING);
    public static final ResearchDiscipline ALCHEMY = ResearchDisciplines.registerDiscipline("ALCHEMY", ((ResearchName)ResearchNames.UNLOCK_ALCHEMY.get()).compoundKey(), PrimalMagick.resource("textures/research/discipline_alchemy.png"), StatsPM.CRAFTED_ALCHEMY);
    public static final ResearchDiscipline SORCERY = ResearchDisciplines.registerDiscipline("SORCERY", ((ResearchName)ResearchNames.UNLOCK_SORCERY.get()).compoundKey(), PrimalMagick.resource("textures/research/discipline_sorcery.png"), StatsPM.CRAFTED_SORCERY);
    public static final ResearchDiscipline RUNEWORKING = ResearchDisciplines.registerDiscipline("RUNEWORKING", ((ResearchName)ResearchNames.UNLOCK_RUNEWORKING.get()).compoundKey(), PrimalMagick.resource("textures/research/discipline_runeworking.png"), StatsPM.CRAFTED_RUNEWORKING);
    public static final ResearchDiscipline RITUAL = ResearchDisciplines.registerDiscipline("RITUAL", ((ResearchName)ResearchNames.UNLOCK_RITUAL.get()).compoundKey(), PrimalMagick.resource("textures/research/discipline_ritual.png"), StatsPM.CRAFTED_RITUAL);
    public static final ResearchDiscipline MAGITECH = ResearchDisciplines.registerDiscipline("MAGITECH", ((ResearchName)ResearchNames.UNLOCK_MAGITECH.get()).compoundKey(), PrimalMagick.resource("textures/research/discipline_magitech.png"), StatsPM.CRAFTED_MAGITECH);
    public static final ResearchDiscipline SCANS = ResearchDisciplines.registerDiscipline("SCANS", ((ResearchName)ResearchNames.UNLOCK_SCANS.get()).compoundKey(), PrimalMagick.resource("textures/item/magnifying_glass.png"), null);

    @Nullable
    public static ResearchDiscipline getDiscipline(String key) {
        return DISCIPLINES.get(key);
    }

    @Nonnull
    public static Collection<ResearchDiscipline> getAllDisciplines() {
        return Collections.unmodifiableCollection(DISCIPLINES.values());
    }

    @Nonnull
    public static List<ResearchDiscipline> getAllDisciplinesSorted() {
        return Collections.unmodifiableList(DISCIPLINES_SORTED);
    }

    @Nullable
    public static ResearchDiscipline registerDiscipline(@Nullable String key, @Nullable CompoundResearchKey unlockResearchKey, @Nullable ResourceLocation icon, @Nullable Stat craftingStat) {
        if (key == null || DISCIPLINES.containsKey(key)) {
            return null;
        }
        ResearchDiscipline discipline = ResearchDiscipline.create(key, unlockResearchKey, icon, craftingStat);
        if (discipline != null) {
            DISCIPLINES.put(key, discipline);
            DISCIPLINES_SORTED.add(discipline);
        }
        return discipline;
    }

    static void clearAllResearch() {
        for (ResearchDiscipline discipline : DISCIPLINES.values()) {
            discipline.clearEntries();
        }
    }
}

