/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchAddendum;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.ResearchStage;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ResearchEntry {
    protected SimpleResearchKey key;
    protected String disciplineKey;
    protected String nameTranslationKey;
    protected Icon icon;
    protected CompoundResearchKey parentResearch;
    protected boolean hidden;
    protected boolean finaleExempt;
    protected List<String> finales = new ArrayList<String>();
    protected List<ResearchStage> stages = new ArrayList<ResearchStage>();
    protected List<ResearchAddendum> addenda = new ArrayList<ResearchAddendum>();

    protected ResearchEntry(@Nonnull SimpleResearchKey key, @Nonnull String disciplineKey, @Nonnull String nameTranslationKey, @Nullable Icon icon) {
        this.key = key;
        this.disciplineKey = disciplineKey;
        this.nameTranslationKey = nameTranslationKey;
        this.hidden = false;
        this.finaleExempt = false;
        this.icon = icon;
    }

    @Nullable
    public static ResearchEntry create(@Nullable SimpleResearchKey key, @Nullable String disciplineKey, @Nullable String nameTranslationKey, @Nullable Icon icon) {
        if (key == null || disciplineKey == null || nameTranslationKey == null) {
            return null;
        }
        return new ResearchEntry(key.stripStage(), disciplineKey, nameTranslationKey, icon);
    }

    @Nonnull
    public static ResearchEntry parse(@Nonnull JsonObject obj) throws Exception {
        ResearchEntry entry = ResearchEntry.create(SimpleResearchKey.parse(obj.getAsJsonPrimitive("key").getAsString()), obj.getAsJsonPrimitive("discipline").getAsString(), obj.getAsJsonPrimitive("name").getAsString(), Icon.parse(obj.getAsJsonObject("icon")));
        if (entry == null) {
            throw new JsonParseException("Invalid entry data in research JSON");
        }
        if (obj.has("hidden")) {
            entry.hidden = obj.getAsJsonPrimitive("hidden").getAsBoolean();
        }
        if (obj.has("finaleExempt")) {
            entry.finaleExempt = obj.getAsJsonPrimitive("finaleExempt").getAsBoolean();
        }
        if (obj.has("parents")) {
            entry.parentResearch = CompoundResearchKey.parse(obj.get("parents").getAsJsonArray());
        }
        if (obj.has("finales")) {
            for (JsonElement element : obj.get("finales").getAsJsonArray()) {
                entry.finales.add(element.getAsString());
            }
        }
        for (JsonElement element : obj.get("stages").getAsJsonArray()) {
            entry.stages.add(ResearchStage.parse(entry, element.getAsJsonObject()));
        }
        if (obj.has("addenda")) {
            for (JsonElement element : obj.get("addenda").getAsJsonArray()) {
                entry.addenda.add(ResearchAddendum.parse(entry, element.getAsJsonObject()));
            }
        }
        return entry;
    }

    @Nonnull
    public static ResearchEntry fromNetwork(FriendlyByteBuf buf) {
        SimpleResearchKey key = SimpleResearchKey.parse(buf.m_130277_());
        String discipline = buf.m_130277_();
        String name = buf.m_130277_();
        Icon icon = Icon.fromNetwork(buf);
        ResearchEntry entry = ResearchEntry.create(key, discipline, name, icon);
        entry.hidden = buf.readBoolean();
        entry.finaleExempt = buf.readBoolean();
        entry.parentResearch = CompoundResearchKey.parse(buf.m_130277_());
        int finaleCount = buf.m_130242_();
        for (int index = 0; index < finaleCount; ++index) {
            entry.finales.add(buf.m_130277_());
        }
        int stageCount = buf.m_130242_();
        for (int index = 0; index < stageCount; ++index) {
            entry.stages.add(ResearchStage.fromNetwork(buf, entry));
        }
        int addendumCount = buf.m_130242_();
        for (int index = 0; index < addendumCount; ++index) {
            entry.addenda.add(ResearchAddendum.fromNetwork(buf, entry));
        }
        return entry;
    }

    public static void toNetwork(FriendlyByteBuf buf, ResearchEntry entry) {
        buf.m_130070_(entry.key.toString());
        buf.m_130070_(entry.disciplineKey);
        buf.m_130070_(entry.nameTranslationKey);
        Icon.toNetwork(buf, entry.icon);
        buf.writeBoolean(entry.hidden);
        buf.writeBoolean(entry.finaleExempt);
        buf.m_130070_(entry.parentResearch == null ? "" : entry.parentResearch.toString());
        buf.m_130130_(entry.finales.size());
        for (String discipline : entry.finales) {
            buf.m_130070_(discipline);
        }
        buf.m_130130_(entry.stages.size());
        for (ResearchStage stage : entry.stages) {
            ResearchStage.toNetwork(buf, stage);
        }
        buf.m_130130_(entry.addenda.size());
        for (ResearchAddendum addendum : entry.addenda) {
            ResearchAddendum.toNetwork(buf, addendum);
        }
    }

    @Nonnull
    public SimpleResearchKey getKey() {
        return this.key;
    }

    @Nonnull
    public String getDisciplineKey() {
        return this.disciplineKey;
    }

    @Nonnull
    public String getNameTranslationKey() {
        return this.nameTranslationKey;
    }

    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    @Nullable
    public CompoundResearchKey getParentResearch() {
        return this.parentResearch;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isFinaleExempt() {
        return this.finaleExempt;
    }

    @Nonnull
    public List<String> getFinaleDisciplines() {
        return Collections.unmodifiableList(this.finales);
    }

    public boolean isFinaleFor(String discipline) {
        return this.finales.contains(discipline);
    }

    @Nonnull
    public List<ResearchStage> getStages() {
        return Collections.unmodifiableList(this.stages);
    }

    public boolean appendStage(@Nullable ResearchStage stage) {
        return stage == null ? false : this.stages.add(stage);
    }

    @Nonnull
    public List<ResearchAddendum> getAddenda() {
        return Collections.unmodifiableList(this.addenda);
    }

    public boolean appendAddendum(@Nullable ResearchAddendum addendum) {
        return addendum == null ? false : this.addenda.add(addendum);
    }

    @Nonnull
    protected IPlayerKnowledge getKnowledge(@Nonnull Player player) {
        return (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge(player).orElseThrow(() -> new IllegalStateException("No knowledge provider for player"));
    }

    public boolean isNew(@Nonnull Player player) {
        return this.getKnowledge(player).hasResearchFlag(this.getKey(), IPlayerKnowledge.ResearchFlag.NEW);
    }

    public boolean isUpdated(@Nonnull Player player) {
        return this.getKnowledge(player).hasResearchFlag(this.getKey(), IPlayerKnowledge.ResearchFlag.UPDATED);
    }

    public boolean isComplete(@Nonnull Player player) {
        return this.getKnowledge(player).getResearchStatus(this.getKey()) == IPlayerKnowledge.ResearchStatus.COMPLETE;
    }

    public boolean isInProgress(@Nonnull Player player) {
        return this.getKnowledge(player).getResearchStatus(this.getKey()) == IPlayerKnowledge.ResearchStatus.IN_PROGRESS;
    }

    public boolean isAvailable(@Nonnull Player player) {
        return this.getParentResearch() == null || this.getParentResearch().isKnownByStrict(player);
    }

    public boolean isUpcoming(@Nonnull Player player) {
        for (SimpleResearchKey parentKey : this.getParentResearch().getKeys()) {
            if (ResearchManager.isOpaque(parentKey) && !parentKey.isKnownBy(player)) {
                return false;
            }
            ResearchEntry parent = ResearchEntries.getEntry(parentKey);
            if (parent == null || parent.isAvailable(player)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public Set<ResourceLocation> getAllRecipeIds() {
        ResearchStage lastStage;
        HashSet<ResourceLocation> retVal = new HashSet<ResourceLocation>();
        ResearchStage researchStage = lastStage = this.stages.isEmpty() ? null : this.stages.get(this.stages.size() - 1);
        if (lastStage != null) {
            retVal.addAll(lastStage.getRecipes());
        }
        for (ResearchAddendum addendum : this.addenda) {
            retVal.addAll(addendum.getRecipes());
        }
        return retVal;
    }

    @Nonnull
    public Set<ResourceLocation> getKnownRecipeIds(Player player) {
        boolean entryComplete;
        HashSet<ResourceLocation> retVal = new HashSet<ResourceLocation>();
        IPlayerKnowledge knowledge = this.getKnowledge(player);
        ResearchStage currentStage = null;
        int currentStageNum = knowledge.getResearchStage(this.key);
        if (currentStageNum >= 0) {
            currentStage = this.getStages().get(Math.min(currentStageNum, this.getStages().size() - 1));
        }
        boolean bl = entryComplete = currentStageNum >= this.getStages().size();
        if (currentStage != null) {
            retVal.addAll(currentStage.getRecipes());
        }
        if (entryComplete) {
            for (ResearchAddendum addendum : this.getAddenda()) {
                if (addendum.getRequiredResearch() != null && !addendum.getRequiredResearch().isKnownByStrict(player)) continue;
                retVal.addAll(addendum.getRecipes());
            }
            for (ResearchEntry searchEntry : ResearchEntries.getAllEntries()) {
                if (searchEntry.getAddenda().isEmpty() || !knowledge.isResearchComplete(searchEntry.getKey())) continue;
                for (ResearchAddendum addendum : searchEntry.getAddenda()) {
                    if (addendum.getRequiredResearch() == null || !addendum.getRequiredResearch().contains(this.getKey()) || !addendum.getRequiredResearch().isKnownByStrict(player)) continue;
                    retVal.addAll(addendum.getRecipes());
                }
            }
        }
        return retVal;
    }

    public static class Icon {
        protected final boolean isItem;
        protected final ResourceLocation location;

        protected Icon(boolean isItem, ResourceLocation location) {
            this.isItem = isItem;
            this.location = location;
        }

        public static Icon of(ItemLike item) {
            return new Icon(true, ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()));
        }

        public static Icon of(ResourceLocation loc) {
            return new Icon(false, loc);
        }

        public boolean isItem() {
            return this.isItem;
        }

        public ResourceLocation getLocation() {
            return this.location;
        }

        @Nullable
        public Item asItem() {
            return this.isItem ? (Item)ForgeRegistries.ITEMS.getValue(this.location) : null;
        }

        public JsonObject toJson() {
            JsonObject retVal = new JsonObject();
            retVal.addProperty("isItem", Boolean.valueOf(this.isItem));
            retVal.addProperty("location", this.location.toString());
            return retVal;
        }

        @Nullable
        public static Icon parse(@Nullable JsonObject obj) {
            if (obj == null) {
                return null;
            }
            boolean isItem = obj.getAsJsonPrimitive("isItem").getAsBoolean();
            ResourceLocation loc = ResourceLocation.m_135820_((String)obj.getAsJsonPrimitive("location").getAsString());
            return loc == null ? null : new Icon(isItem, loc);
        }

        @Nullable
        public static Icon fromNetwork(FriendlyByteBuf buf) {
            boolean hasIcon = buf.readBoolean();
            if (!hasIcon) {
                return null;
            }
            boolean isItem = buf.readBoolean();
            ResourceLocation loc = ResourceLocation.m_135820_((String)buf.m_130277_());
            return loc == null ? null : new Icon(isItem, loc);
        }

        public static void toNetwork(FriendlyByteBuf buf, @Nullable Icon icon) {
            if (icon == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.writeBoolean(icon.isItem);
                buf.m_130070_(icon.location.toString());
            }
        }
    }
}

