/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research;

import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.IResearchKey;
import com.verdantartifice.primalmagick.common.research.QuorumResearchKey;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import javax.annotation.Nonnull;

public class ResearchKeyFactory {
    public static IResearchKey parse(@Nonnull String keyStr) {
        if (keyStr == null) {
            throw new IllegalArgumentException("Key string may not be null");
        }
        if (keyStr.isEmpty()) {
            return SimpleResearchKey.EMPTY;
        }
        if (keyStr.startsWith("?") && keyStr.contains(":")) {
            return QuorumResearchKey.parse(keyStr);
        }
        if (keyStr.contains("&&") || keyStr.contains("||")) {
            return CompoundResearchKey.parse(keyStr);
        }
        return SimpleResearchKey.parse(keyStr);
    }
}

