/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research;

import com.google.common.collect.ImmutableSet;
import com.verdantartifice.primalmagick.common.affinities.AffinityManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementType;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBookManager;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.IScanTrigger;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.research.ResearchAddendum;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.ResearchStage;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResearchManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<Integer> CRAFTING_REFERENCES = new HashSet<Integer>();
    private static final Set<UUID> SYNC_SET = ConcurrentHashMap.newKeySet();
    private static final List<IScanTrigger> SCAN_TRIGGERS = new ArrayList<IScanTrigger>();
    private static final Map<ResourceLocation, ResearchEntry> RECIPE_MAP = new HashMap<ResourceLocation, ResearchEntry>();
    private static final Set<SimpleResearchKey> OPAQUE_RESEARCH = ImmutableSet.of((Object)Source.BLOOD.getDiscoverKey(), (Object)Source.INFERNAL.getDiscoverKey(), (Object)Source.VOID.getDiscoverKey(), (Object)Source.HALLOWED.getDiscoverKey(), (Object)SimpleResearchKey.parse("t_discover_forbidden"));

    public static Set<Integer> getAllCraftingReferences() {
        return Collections.unmodifiableSet(CRAFTING_REFERENCES);
    }

    public static boolean addCraftingReference(int reference) {
        return CRAFTING_REFERENCES.add(reference);
    }

    static void clearCraftingReferences() {
        CRAFTING_REFERENCES.clear();
    }

    @Nullable
    public static ResearchEntry getEntryForRecipe(ResourceLocation recipeId) {
        return RECIPE_MAP.get(recipeId);
    }

    static void addRecipeMapping(ResourceLocation recipeId, ResearchEntry entry) {
        RECIPE_MAP.put(recipeId, entry);
    }

    static void clearRecipeMap() {
        RECIPE_MAP.clear();
    }

    public static boolean isOpaque(SimpleResearchKey key) {
        return OPAQUE_RESEARCH.contains(key);
    }

    public static boolean isRecipeVisible(ResourceLocation recipeId, Player player) {
        ResearchStage currentStage;
        IPlayerKnowledge know = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge(player).orElseThrow(() -> new IllegalStateException("No knowledge provider for player"));
        ResearchEntry entry = ResearchManager.getEntryForRecipe(recipeId);
        if (entry == null) {
            return true;
        }
        int currentStageIndex = know.getResearchStage(entry.getKey());
        if (currentStageIndex == entry.getStages().size() ? (currentStage = entry.getStages().get(currentStageIndex - 1)).getRecipes().contains(recipeId) : currentStageIndex >= 0 && currentStageIndex < entry.getStages().size() && (currentStage = entry.getStages().get(currentStageIndex)).getRecipes().contains(recipeId)) {
            return true;
        }
        for (ResearchAddendum addendum : entry.getAddenda()) {
            if (addendum.getRequiredResearch() == null || !addendum.getRecipes().contains(recipeId) || !addendum.getRequiredResearch().isKnownByStrict(player)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSyncScheduled(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        return SYNC_SET.remove(player.m_20148_());
    }

    public static void scheduleSync(@Nullable Player player) {
        if (player != null) {
            SYNC_SET.add(player.m_20148_());
        }
    }

    public static boolean hasPrerequisites(@Nullable Player player, @Nullable SimpleResearchKey key) {
        if (player == null) {
            return false;
        }
        if (key == null) {
            return true;
        }
        ResearchEntry entry = ResearchEntries.getEntry(key);
        if (entry == null || entry.getParentResearch() == null) {
            return true;
        }
        return entry.getParentResearch().isKnownByStrict(player);
    }

    public static boolean isResearchComplete(@Nullable Player player, @Nullable SimpleResearchKey key) {
        if (player == null || key == null) {
            return false;
        }
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge(player).orElse(null);
        if (knowledge == null) {
            return false;
        }
        return knowledge.isResearchComplete(key);
    }

    public static boolean completeResearch(@Nullable Player player, @Nullable SimpleResearchKey key) {
        return ResearchManager.completeResearch(player, key, true);
    }

    public static boolean completeResearch(@Nullable Player player, @Nullable SimpleResearchKey key, boolean sync) {
        return ResearchManager.completeResearch(player, key, sync, true, true);
    }

    public static boolean completeResearch(@Nullable Player player, @Nullable SimpleResearchKey key, boolean sync, boolean showNewFlags, boolean showPopups) {
        boolean retVal = false;
        while (ResearchManager.progressResearch(player, key, sync, showNewFlags, showPopups)) {
            retVal = true;
        }
        return retVal;
    }

    public static void forceGrantWithAllParents(@Nullable Player player, @Nullable SimpleResearchKey key) {
        if (player != null && key != null) {
            PrimalMagickCapabilities.getKnowledge(player).ifPresent(knowledge -> {
                SimpleResearchKey strippedKey = key.stripStage();
                if (!knowledge.isResearchComplete(strippedKey)) {
                    ResearchEntry entry = ResearchEntries.getEntry(strippedKey);
                    if (entry != null) {
                        if (entry.getParentResearch() != null) {
                            for (SimpleResearchKey parentKey : entry.getParentResearch().getKeys()) {
                                ResearchManager.forceGrantWithAllParents(player, parentKey);
                            }
                        }
                        for (ResearchStage stage : entry.getStages()) {
                            for (SimpleResearchKey requiredKey : stage.getRequiredResearch().getKeys()) {
                                ResearchManager.completeResearch(player, requiredKey, true, true, false);
                            }
                        }
                    }
                    ResearchManager.completeResearch(player, strippedKey, true, true, false);
                    block3: for (ResearchEntry searchEntry : ResearchEntries.getAllEntries()) {
                        for (ResearchStage searchStage : searchEntry.getStages()) {
                            if (!searchStage.getRequiredResearch().contains(strippedKey)) continue;
                            knowledge.addResearchFlag(searchEntry.getKey(), IPlayerKnowledge.ResearchFlag.UPDATED);
                            continue block3;
                        }
                    }
                }
            });
        }
    }

    public static void forceGrantParentsOnly(@Nullable Player player, @Nullable SimpleResearchKey key) {
        if (player != null && key != null) {
            PrimalMagickCapabilities.getKnowledge(player).ifPresent(knowledge -> {
                ResearchEntry entry;
                SimpleResearchKey strippedKey = key.stripStage();
                if (!knowledge.isResearchComplete(strippedKey) && (entry = ResearchEntries.getEntry(strippedKey)) != null) {
                    if (entry.getParentResearch() != null) {
                        for (SimpleResearchKey parentKey : entry.getParentResearch().getKeys()) {
                            ResearchManager.forceGrantWithAllParents(player, parentKey);
                        }
                    }
                    for (ResearchStage stage : entry.getStages()) {
                        for (SimpleResearchKey requiredKey : stage.getRequiredResearch().getKeys()) {
                            ResearchManager.completeResearch(player, requiredKey, true, true, false);
                        }
                    }
                }
            });
        }
    }

    public static void forceGrantAll(@Nullable Player player) {
        if (player != null) {
            for (ResearchEntry entry : ResearchEntries.getAllEntries()) {
                ResearchManager.forceGrantWithAllParents(player, entry.getKey());
            }
        }
    }

    public static void forceRevokeWithAllChildren(@Nullable Player player, @Nullable SimpleResearchKey key) {
        if (player != null && key != null) {
            PrimalMagickCapabilities.getKnowledge(player).ifPresent(knowledge -> {
                if (knowledge.isResearchComplete(key)) {
                    for (ResearchEntry entry : ResearchEntries.getAllEntries()) {
                        CompoundResearchKey parentResearch = entry.getParentResearch();
                        if (parentResearch == null || !parentResearch.containsStripped(key)) continue;
                        ResearchManager.forceRevokeWithAllChildren(player, entry.getKey());
                    }
                    ResearchManager.revokeResearch(player, key.stripStage());
                }
            });
        }
    }

    public static boolean revokeResearch(@Nullable Player player, @Nullable SimpleResearchKey key) {
        return ResearchManager.revokeResearch(player, key, true);
    }

    public static boolean revokeResearch(@Nullable Player player, @Nullable SimpleResearchKey key, boolean sync) {
        if (player == null || key == null) {
            return false;
        }
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge(player).orElse(null);
        if (knowledge == null) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ResearchEntry entry = ResearchEntries.getEntry(key);
            if (entry != null) {
                RecipeManager recipeManager = serverPlayer.m_9236_().m_7465_();
                Set<Recipe<?>> recipesToRemove = entry.getAllRecipeIds().stream().map(r -> recipeManager.m_44043_(r).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
                ArcaneRecipeBookManager.removeRecipes(recipesToRemove, serverPlayer);
                serverPlayer.m_7279_(recipesToRemove);
            }
        }
        knowledge.removeResearch(key);
        if (sync) {
            ResearchManager.scheduleSync(player);
        }
        return true;
    }

    public static boolean progressResearch(@Nullable Player player, @Nullable SimpleResearchKey key) {
        return ResearchManager.progressResearch(player, key, true);
    }

    public static boolean progressResearch(@Nullable Player player, @Nullable SimpleResearchKey key, boolean sync) {
        return ResearchManager.progressResearch(player, key, sync, true, true);
    }

    public static boolean progressResearch(@Nullable Player player, @Nullable SimpleResearchKey key, boolean sync, boolean showNewFlags, boolean showPopups) {
        Object source;
        if (player == null || key == null) {
            return false;
        }
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge(player).orElse(null);
        if (knowledge == null) {
            return false;
        }
        if (knowledge.isResearchComplete(key) || !ResearchManager.hasPrerequisites(player, key)) {
            return false;
        }
        boolean added = false;
        if (!knowledge.isResearchKnown(key)) {
            knowledge.addResearch(key);
            added = true;
        }
        ResearchEntry entry = ResearchEntries.getEntry(key);
        boolean entryComplete = true;
        if (entry != null && !entry.getStages().isEmpty()) {
            ResearchStage currentStage = null;
            int currentStageNum = knowledge.getResearchStage(key);
            if (!added) {
                ++currentStageNum;
            }
            if (currentStageNum == entry.getStages().size() - 1 && !entry.getStages().get(currentStageNum).hasPrerequisites()) {
                ++currentStageNum;
            }
            if ((currentStageNum = Math.min(currentStageNum, entry.getStages().size())) >= 0) {
                currentStage = entry.getStages().get(Math.min(currentStageNum, entry.getStages().size() - 1));
            }
            knowledge.setResearchStage(key, currentStageNum);
            boolean bl = entryComplete = currentStageNum >= entry.getStages().size();
            if (currentStage != null) {
                SourceList sourceList = currentStage.getAttunements();
                for (Source source2 : sourceList.getSources()) {
                    int amount = sourceList.getAmount(source2);
                    if (amount <= 0) continue;
                    AttunementManager.incrementAttunement(player, source2, AttunementType.PERMANENT, amount);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    RecipeManager recipeManager = serverPlayer.m_9236_().m_7465_();
                    Set<Recipe<?>> recipesToUnlock = currentStage.getRecipes().stream().map(r -> recipeManager.m_44043_(r).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
                    ArcaneRecipeBookManager.addRecipes(recipesToUnlock, serverPlayer);
                    serverPlayer.m_7281_(recipesToUnlock);
                }
                for (SimpleResearchKey simpleResearchKey : currentStage.getSiblings()) {
                    ResearchManager.completeResearch(player, simpleResearchKey, sync);
                }
                for (SimpleResearchKey simpleResearchKey : currentStage.getRevelations()) {
                    if (knowledge.isResearchKnown(simpleResearchKey)) continue;
                    knowledge.addResearch(simpleResearchKey);
                    if (showPopups) {
                        knowledge.addResearchFlag(simpleResearchKey, IPlayerKnowledge.ResearchFlag.POPUP);
                    }
                    knowledge.addResearchFlag(simpleResearchKey, IPlayerKnowledge.ResearchFlag.NEW);
                }
            }
            if (entryComplete && !entry.getAddenda().isEmpty() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                RecipeManager recipeManager = serverPlayer.m_9236_().m_7465_();
                for (ResearchAddendum addendum : entry.getAddenda()) {
                    if (addendum.getRequiredResearch() != null && !addendum.getRequiredResearch().isKnownByStrict(player)) continue;
                    Set recipesToUnlock = addendum.getRecipes().stream().map(r -> recipeManager.m_44043_(r).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
                    ArcaneRecipeBookManager.addRecipes(recipesToUnlock, serverPlayer);
                    serverPlayer.m_7281_((Collection)recipesToUnlock);
                    for (SimpleResearchKey sibling : addendum.getSiblings()) {
                        ResearchManager.completeResearch(player, sibling, sync);
                    }
                }
            }
            if (!added) {
                player.m_6756_(5);
            }
        }
        if (Source.isSourceDiscoverKey(key) && (source = Source.getSource(key)) != null) {
            LOGGER.debug("Unlocking sibling research for source {}", (Object)((Source)source).getTag());
            for (SimpleResearchKey simpleResearchKey : ((Source)source).getSiblings()) {
                ResearchManager.completeResearch(player, simpleResearchKey, sync);
            }
        }
        if (entryComplete) {
            ResearchDiscipline discipline;
            if (sync) {
                if (showPopups) {
                    knowledge.addResearchFlag(key, IPlayerKnowledge.ResearchFlag.POPUP);
                }
                if (showNewFlags) {
                    knowledge.addResearchFlag(key, IPlayerKnowledge.ResearchFlag.NEW);
                }
            }
            for (ResearchEntry searchEntry : ResearchEntries.getAllEntries()) {
                if (searchEntry.getAddenda().isEmpty() || !knowledge.isResearchComplete(searchEntry.getKey())) continue;
                for (ResearchAddendum addendum : searchEntry.getAddenda()) {
                    if (addendum.getRequiredResearch() == null || !addendum.getRequiredResearch().contains(key) || !addendum.getRequiredResearch().isKnownByStrict(player)) continue;
                    MutableComponent mutableComponent = Component.m_237115_((String)searchEntry.getNameTranslationKey());
                    player.m_213846_((Component)Component.m_237110_((String)"event.primalmagick.add_addendum", (Object[])new Object[]{mutableComponent}));
                    knowledge.addResearchFlag(searchEntry.getKey(), IPlayerKnowledge.ResearchFlag.UPDATED);
                    SourceList attunements = addendum.getAttunements();
                    for (Source source3 : attunements.getSources()) {
                        int amount = attunements.getAmount(source3);
                        if (amount <= 0) continue;
                        AttunementManager.incrementAttunement(player, source3, AttunementType.PERMANENT, amount);
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        RecipeManager recipeManager = serverPlayer.m_9236_().m_7465_();
                        Set<Recipe<?>> recipesToUnlock = addendum.getRecipes().stream().map(r -> recipeManager.m_44043_(r).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
                        ArcaneRecipeBookManager.addRecipes(recipesToUnlock, serverPlayer);
                        serverPlayer.m_7281_(recipesToUnlock);
                    }
                    for (SimpleResearchKey sibling : addendum.getSiblings()) {
                        ResearchManager.completeResearch(player, sibling, sync);
                    }
                }
            }
            if (entry != null && (discipline = ResearchDisciplines.getDiscipline(entry.getDisciplineKey())) != null) {
                for (ResearchEntry researchEntry : discipline.getFinaleEntries()) {
                    boolean bl;
                    SimpleResearchKey finaleKey = researchEntry.getKey();
                    if (knowledge.isResearchKnown(finaleKey) || !(bl = researchEntry.getFinaleDisciplines().stream().map(ResearchDisciplines::getDiscipline).filter(Objects::nonNull).flatMap(d -> d.getEntries().stream()).filter(e -> e.getFinaleDisciplines().isEmpty() && !e.isFinaleExempt()).allMatch(e -> e.isComplete(player)))) continue;
                    knowledge.addResearch(finaleKey);
                    if (showPopups) {
                        knowledge.addResearchFlag(finaleKey, IPlayerKnowledge.ResearchFlag.POPUP);
                    }
                    knowledge.addResearchFlag(finaleKey, IPlayerKnowledge.ResearchFlag.NEW);
                }
            }
        }
        if (sync) {
            ResearchManager.scheduleSync(player);
        }
        return true;
    }

    public static boolean addKnowledge(Player player, KnowledgeType type, int points) {
        return ResearchManager.addKnowledge(player, type, points, true);
    }

    public static boolean addKnowledge(Player player, KnowledgeType type, int points, boolean scheduleSync) {
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge(player).orElse(null);
        if (knowledge == null) {
            return false;
        }
        int levelsBefore = knowledge.getKnowledge(type);
        boolean success = knowledge.addKnowledge(type, points);
        if (!success) {
            return false;
        }
        if (points > 0) {
            int levelsAfter = knowledge.getKnowledge(type);
            int delta = levelsAfter - levelsBefore;
            if (type == KnowledgeType.OBSERVATION) {
                StatsManager.incrementValue(player, StatsPM.OBSERVATIONS_MADE, delta);
            } else if (type == KnowledgeType.THEORY) {
                StatsManager.incrementValue(player, StatsPM.THEORIES_FORMED, delta);
            }
            for (int index = 0; index < delta; ++index) {
            }
        }
        if (scheduleSync) {
            ResearchManager.scheduleSync(player);
        }
        return true;
    }

    public static boolean registerScanTrigger(@Nullable IScanTrigger trigger) {
        if (trigger == null) {
            return false;
        }
        return SCAN_TRIGGERS.add(trigger);
    }

    public static void checkScanTriggers(ServerPlayer player, ItemLike itemProvider) {
        ResearchManager.checkScanTriggersInner(player, itemProvider);
    }

    public static void checkScanTriggers(ServerPlayer player, EntityType<?> entityType) {
        ResearchManager.checkScanTriggersInner(player, entityType);
    }

    private static void checkScanTriggersInner(ServerPlayer player, Object obj) {
        for (IScanTrigger trigger : SCAN_TRIGGERS) {
            if (!trigger.matches(player, obj)) continue;
            trigger.onMatch(player, obj);
        }
    }

    public static boolean hasScanTriggers(ServerPlayer player, ItemLike itemProvider) {
        return ResearchManager.hasScanTriggersInner(player, itemProvider);
    }

    public static boolean hasScanTriggers(ServerPlayer player, EntityType<?> entityType) {
        return ResearchManager.hasScanTriggersInner(player, entityType);
    }

    private static boolean hasScanTriggersInner(ServerPlayer player, Object obj) {
        for (IScanTrigger trigger : SCAN_TRIGGERS) {
            if (!trigger.matches(player, obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean isScanned(@Nullable ItemStack stack, @Nullable Player player) {
        if (stack == null || stack.m_41619_() || player == null) {
            return false;
        }
        Optional<SourceList> affinitiesOpt = AffinityManager.getInstance().getAffinityValues(stack, player.m_9236_());
        if (affinitiesOpt.isPresent()) {
            SourceList affinities = affinitiesOpt.get();
            if (!(affinities != null && !affinities.isEmpty() || player instanceof ServerPlayer && ResearchManager.hasScanTriggers((ServerPlayer)player, (ItemLike)stack.m_41720_()))) {
                return true;
            }
            SimpleResearchKey key = SimpleResearchKey.parseItemScan(stack);
            return key != null && key.isKnownByStrict(player);
        }
        return true;
    }

    public static CompletableFuture<Boolean> isScannedAsync(@Nullable ItemStack stack, @Nullable Player player) {
        if (stack == null || stack.m_41619_() || player == null) {
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        return AffinityManager.getInstance().getAffinityValuesAsync(stack, player.m_9236_()).thenApply(affinities -> {
            if (!(affinities != null && !affinities.isEmpty() || player instanceof ServerPlayer && ResearchManager.hasScanTriggers((ServerPlayer)player, (ItemLike)stack.m_41720_()))) {
                return true;
            }
            SimpleResearchKey key = SimpleResearchKey.parseItemScan(stack);
            return key != null && key.isKnownByStrict(player);
        });
    }

    public static boolean isScanned(@Nullable EntityType<?> type, @Nullable Player player) {
        if (type == null || player == null) {
            return false;
        }
        Optional<SourceList> affinitiesOpt = AffinityManager.getInstance().getAffinityValues(type, player.m_9236_().m_9598_());
        if (affinitiesOpt.isPresent()) {
            SourceList affinities = affinitiesOpt.get();
            if (!(affinities != null && !affinities.isEmpty() || player instanceof ServerPlayer && ResearchManager.hasScanTriggers((ServerPlayer)player, type))) {
                return true;
            }
            SimpleResearchKey key = SimpleResearchKey.parseEntityScan(type);
            return key != null && key.isKnownByStrict(player);
        }
        return true;
    }

    public static CompletableFuture<Boolean> isScannedAsync(@Nullable EntityType<?> type, @Nullable Player player) {
        if (type == null || player == null) {
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        return AffinityManager.getInstance().getAffinityValuesAsync(type, player.m_9236_().m_9598_()).thenApply(affinities -> {
            if (!(affinities != null && !affinities.isEmpty() || player instanceof ServerPlayer && ResearchManager.hasScanTriggers((ServerPlayer)player, type))) {
                return true;
            }
            SimpleResearchKey key = SimpleResearchKey.parseEntityScan(type);
            return key != null && key.isKnownByStrict(player);
        });
    }

    public static boolean setScanned(@Nullable ItemStack stack, @Nullable ServerPlayer player) {
        return ResearchManager.setScanned(stack, player, true);
    }

    public static boolean setScanned(@Nullable ItemStack stack, @Nullable ServerPlayer player, boolean sync) {
        if (stack == null || stack.m_41619_() || player == null) {
            return false;
        }
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge((Player)player).orElse(null);
        if (knowledge == null) {
            return false;
        }
        ResearchManager.checkScanTriggers(player, (ItemLike)stack.m_41720_());
        SimpleResearchKey key = SimpleResearchKey.parseItemScan(stack);
        if (key != null && knowledge.addResearch(key)) {
            ResearchManager.getObservationPointsAsync(stack, player.m_20193_()).thenAccept(obsPoints -> {
                if (obsPoints > 0) {
                    ResearchManager.addKnowledge((Player)player, KnowledgeType.OBSERVATION, obsPoints, false);
                }
            });
            StatsManager.incrementValue((Player)player, StatsPM.ITEMS_ANALYZED);
            if (sync) {
                knowledge.sync(player);
            }
            return true;
        }
        return false;
    }

    public static boolean setScanned(@Nullable EntityType<?> type, @Nullable ServerPlayer player) {
        return ResearchManager.setScanned(type, player, true);
    }

    public static boolean setScanned(@Nullable EntityType<?> type, @Nullable ServerPlayer player, boolean sync) {
        if (type == null || player == null) {
            return false;
        }
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge((Player)player).orElse(null);
        if (knowledge == null) {
            return false;
        }
        SimpleResearchKey key = SimpleResearchKey.parseEntityScan(type);
        if (key != null && knowledge.addResearch(key)) {
            ResearchManager.getObservationPointsAsync(type, player.m_20193_()).thenAccept(obsPoints -> {
                if (obsPoints > 0) {
                    ResearchManager.addKnowledge((Player)player, KnowledgeType.OBSERVATION, obsPoints, false);
                }
            });
            StatsManager.incrementValue((Player)player, StatsPM.ENTITIES_ANALYZED);
            ResearchManager.checkScanTriggers(player, type);
            if (sync) {
                knowledge.sync(player);
            }
            return true;
        }
        return false;
    }

    public static int setAllScanned(@Nullable ServerPlayer player) {
        if (player == null) {
            return 0;
        }
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge((Player)player).orElse(null);
        if (knowledge == null) {
            return 0;
        }
        int count = 0;
        ArrayList<CompletableFuture<Integer>> obsPointsFutures = new ArrayList<CompletableFuture<Integer>>();
        for (Item item : ForgeRegistries.ITEMS) {
            SimpleResearchKey key;
            ItemStack stack = new ItemStack((ItemLike)item);
            if (stack.m_41619_() || (key = SimpleResearchKey.parseItemScan(stack)) == null || !knowledge.addResearch(key)) continue;
            ++count;
            obsPointsFutures.add(ResearchManager.getObservationPointsAsync(stack, player.m_20193_()));
            ResearchManager.checkScanTriggers(player, (ItemLike)item);
        }
        Util.m_137567_(obsPointsFutures).thenAccept(obsPointsList -> {
            int obsPoints = obsPointsList.stream().mapToInt(i -> i).sum();
            if (obsPoints > 0) {
                ResearchManager.addKnowledge((Player)player, KnowledgeType.OBSERVATION, obsPoints, false);
            }
        });
        if (count > 0) {
            knowledge.sync(player);
        }
        return count;
    }

    private static CompletableFuture<Integer> getObservationPointsAsync(@Nonnull ItemStack stack, @Nonnull Level world) {
        return AffinityManager.getInstance().getAffinityValuesAsync(stack, world).thenApply(ResearchManager::getObservationPoints);
    }

    private static CompletableFuture<Integer> getObservationPointsAsync(@Nonnull EntityType<?> type, @Nonnull Level level) {
        return AffinityManager.getInstance().getAffinityValuesAsync(type, level.m_9598_()).thenApply(ResearchManager::getObservationPoints);
    }

    private static int getObservationPoints(@Nullable SourceList affinities) {
        if (affinities == null || affinities.isEmpty()) {
            return 0;
        }
        double total = 0.0;
        for (Source source : affinities.getSources()) {
            total += (double)affinities.getAmount(source) * source.getObservationMultiplier();
        }
        if (total > 0.0) {
            total = Math.sqrt(total);
        }
        return Mth.m_14165_((double)total);
    }
}

