/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.Knowledge;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.util.InventoryUtils;
import com.verdantartifice.primalmagick.common.util.ItemUtils;
import com.verdantartifice.primalmagick.common.util.JsonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ResearchStage {
    protected ResearchEntry researchEntry;
    protected String textTranslationKey;
    protected List<ResourceLocation> recipes = new ArrayList<ResourceLocation>();
    protected List<Object> mustObtain = new ArrayList<Object>();
    protected List<Object> mustCraft = new ArrayList<Object>();
    protected List<Integer> craftReference = new ArrayList<Integer>();
    protected List<Knowledge> requiredKnowledge = new ArrayList<Knowledge>();
    protected List<SimpleResearchKey> siblings = new ArrayList<SimpleResearchKey>();
    protected List<SimpleResearchKey> revelations = new ArrayList<SimpleResearchKey>();
    protected List<SimpleResearchKey> hints = new ArrayList<SimpleResearchKey>();
    protected CompoundResearchKey requiredResearch;
    protected SourceList attunements = SourceList.EMPTY;

    protected ResearchStage(@Nonnull ResearchEntry entry, @Nonnull String textTranslationKey) {
        this.researchEntry = entry;
        this.textTranslationKey = textTranslationKey;
    }

    @Nullable
    public static ResearchStage create(@Nonnull ResearchEntry entry, @Nullable String textTranslationKey) {
        return textTranslationKey == null ? null : new ResearchStage(entry, textTranslationKey);
    }

    @Nonnull
    public static ResearchStage parse(@Nonnull ResearchEntry entry, @Nonnull JsonObject obj) throws Exception {
        ResearchStage stage = ResearchStage.create(entry, obj.getAsJsonPrimitive("text").getAsString());
        if (stage == null) {
            throw new JsonParseException("Illegal stage text in research JSON");
        }
        if (obj.has("recipes")) {
            stage.recipes = JsonUtils.toResourceLocations(obj.get("recipes").getAsJsonArray());
        }
        if (obj.has("required_item")) {
            stage.mustObtain = JsonUtils.toOres(obj.get("required_item").getAsJsonArray());
        }
        if (obj.has("required_craft")) {
            stage.mustCraft = JsonUtils.toOres(obj.get("required_craft").getAsJsonArray());
            ArrayList<Integer> references = new ArrayList<Integer>();
            for (Object craftObj : stage.mustCraft) {
                int code = craftObj instanceof ItemStack ? ItemUtils.getHashCode((ItemStack)craftObj) : ("tag:" + craftObj.toString()).hashCode();
                references.add(code);
                ResearchManager.addCraftingReference(code);
            }
            stage.craftReference = references;
        }
        if (obj.has("required_knowledge")) {
            List<String> knowledgeStrs = JsonUtils.toStrings(obj.get("required_knowledge").getAsJsonArray());
            stage.requiredKnowledge = knowledgeStrs.stream().map(s -> Knowledge.parse(s)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (obj.has("siblings")) {
            stage.siblings = JsonUtils.toSimpleResearchKeys(obj.get("siblings").getAsJsonArray());
        }
        if (obj.has("revelations")) {
            stage.revelations = JsonUtils.toSimpleResearchKeys(obj.get("revelations").getAsJsonArray());
        }
        if (obj.has("hints")) {
            stage.hints = JsonUtils.toSimpleResearchKeys(obj.get("hints").getAsJsonArray());
        }
        if (obj.has("required_research")) {
            stage.requiredResearch = CompoundResearchKey.parse(obj.get("required_research").getAsJsonArray());
        }
        if (obj.has("attunements")) {
            stage.attunements = JsonUtils.toSourceList(obj.get("attunements").getAsJsonObject());
        }
        return stage;
    }

    @Nonnull
    public static ResearchStage fromNetwork(FriendlyByteBuf buf, ResearchEntry entry) {
        ResearchStage stage = ResearchStage.create(entry, buf.m_130277_());
        int recipeSize = buf.m_130242_();
        for (int index = 0; index < recipeSize; ++index) {
            stage.recipes.add(new ResourceLocation(buf.m_130277_()));
        }
        int obtainSize = buf.m_130242_();
        for (int index = 0; index < obtainSize; ++index) {
            stage.mustObtain.add(buf.readBoolean() ? buf.m_130267_() : new ResourceLocation(buf.m_130277_()));
        }
        int craftSize = buf.m_130242_();
        for (int index = 0; index < craftSize; ++index) {
            stage.mustCraft.add(buf.readBoolean() ? buf.m_130267_() : new ResourceLocation(buf.m_130277_()));
        }
        int refSize = buf.m_130242_();
        for (int index = 0; index < refSize; ++index) {
            int ref = buf.m_130242_();
            stage.craftReference.add(ref);
        }
        int knowSize = buf.m_130242_();
        for (int index = 0; index < knowSize; ++index) {
            stage.requiredKnowledge.add(Knowledge.parse(buf.m_130277_()));
        }
        int siblingSize = buf.m_130242_();
        for (int index = 0; index < siblingSize; ++index) {
            stage.siblings.add(SimpleResearchKey.parse(buf.m_130277_()));
        }
        int revelationsSize = buf.m_130242_();
        for (int index = 0; index < revelationsSize; ++index) {
            stage.revelations.add(SimpleResearchKey.parse(buf.m_130277_()));
        }
        int hintsSize = buf.m_130242_();
        for (int index = 0; index < hintsSize; ++index) {
            stage.hints.add(SimpleResearchKey.parse(buf.m_130277_()));
        }
        stage.requiredResearch = CompoundResearchKey.parse(buf.m_130277_());
        stage.attunements = SourceList.fromNetwork(buf);
        return stage;
    }

    public static void toNetwork(FriendlyByteBuf buf, ResearchStage stage) {
        buf.m_130070_(stage.textTranslationKey);
        buf.m_130130_(stage.recipes.size());
        for (ResourceLocation recipe : stage.recipes) {
            buf.m_130070_(recipe.toString());
        }
        buf.m_130130_(stage.mustObtain.size());
        for (Object obj : stage.mustObtain) {
            if (obj instanceof ItemStack) {
                buf.writeBoolean(true);
                buf.m_130055_((ItemStack)obj);
                continue;
            }
            buf.writeBoolean(false);
            buf.m_130070_(obj.toString());
        }
        buf.m_130130_(stage.mustCraft.size());
        for (Object obj : stage.mustCraft) {
            if (obj instanceof ItemStack) {
                buf.writeBoolean(true);
                buf.m_130055_((ItemStack)obj);
                continue;
            }
            buf.writeBoolean(false);
            buf.m_130070_(obj.toString());
        }
        buf.m_130130_(stage.craftReference.size());
        for (Integer ref : stage.craftReference) {
            buf.m_130130_(ref.intValue());
        }
        buf.m_130130_(stage.requiredKnowledge.size());
        for (Knowledge know : stage.requiredKnowledge) {
            buf.m_130070_(know.toString());
        }
        buf.m_130130_(stage.siblings.size());
        for (SimpleResearchKey key : stage.siblings) {
            buf.m_130070_(key.toString());
        }
        buf.m_130130_(stage.revelations.size());
        for (SimpleResearchKey key : stage.revelations) {
            buf.m_130070_(key.toString());
        }
        buf.m_130130_(stage.hints.size());
        for (SimpleResearchKey key : stage.hints) {
            buf.m_130070_(key.toString());
        }
        buf.m_130070_(stage.requiredResearch == null ? "" : stage.requiredResearch.toString());
        SourceList.toNetwork(buf, stage.attunements);
    }

    @Nonnull
    public ResearchEntry getResearchEntry() {
        return this.researchEntry;
    }

    @Nonnull
    public String getTextTranslationKey() {
        return this.textTranslationKey;
    }

    @Nonnull
    public List<ResourceLocation> getRecipes() {
        return Collections.unmodifiableList(this.recipes);
    }

    @Nonnull
    public List<Object> getMustObtain() {
        return Collections.unmodifiableList(this.mustObtain);
    }

    @Nonnull
    public List<Object> getMustCraft() {
        return Collections.unmodifiableList(this.mustCraft);
    }

    @Nonnull
    public List<Integer> getCraftReference() {
        return Collections.unmodifiableList(this.craftReference);
    }

    @Nonnull
    public List<Knowledge> getRequiredKnowledge() {
        return Collections.unmodifiableList(this.requiredKnowledge);
    }

    @Nonnull
    public List<SimpleResearchKey> getSiblings() {
        return Collections.unmodifiableList(this.siblings);
    }

    @Nonnull
    public List<SimpleResearchKey> getRevelations() {
        return Collections.unmodifiableList(this.revelations);
    }

    @Nonnull
    public List<SimpleResearchKey> getHints() {
        return Collections.unmodifiableList(this.hints);
    }

    @Nonnull
    public CompoundResearchKey getRequiredResearch() {
        return this.requiredResearch == null ? CompoundResearchKey.EMPTY : this.requiredResearch;
    }

    @Nonnull
    public SourceList getAttunements() {
        return this.attunements;
    }

    public boolean hasPrerequisites() {
        return !this.mustObtain.isEmpty() || !this.mustCraft.isEmpty() || !this.requiredKnowledge.isEmpty() || this.requiredResearch != null && !this.requiredResearch.isEmpty();
    }

    public boolean arePrerequisitesMet(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge(player).orElse(null);
        if (knowledge == null) {
            return false;
        }
        for (Object obtainObj : this.mustObtain) {
            if (obtainObj instanceof ItemStack && !InventoryUtils.isPlayerCarrying(player, (ItemStack)obtainObj)) {
                return false;
            }
            if (!(obtainObj instanceof ResourceLocation) || InventoryUtils.isPlayerCarrying(player, (ResourceLocation)obtainObj, 1)) continue;
            return false;
        }
        for (Integer craftRef : this.craftReference) {
            if (knowledge.isResearchKnown(SimpleResearchKey.parseCrafted(craftRef))) continue;
            return false;
        }
        for (Knowledge knowPacket : this.requiredKnowledge) {
            if (knowledge.getKnowledge(knowPacket.getType()) >= knowPacket.getAmount()) continue;
            return false;
        }
        return this.requiredResearch == null || this.requiredResearch.isKnownByStrict(player);
    }

    public List<Boolean> getObtainRequirementCompletion(@Nullable Player player) {
        if (this.mustObtain.isEmpty()) {
            return Collections.emptyList();
        }
        if (player == null) {
            return Collections.nCopies(this.mustObtain.size(), Boolean.FALSE);
        }
        ArrayList<Boolean> retVal = new ArrayList<Boolean>();
        for (Object obj : this.mustObtain) {
            if (obj instanceof ItemStack) {
                retVal.add(InventoryUtils.isPlayerCarrying(player, (ItemStack)obj));
                continue;
            }
            if (obj instanceof ResourceLocation) {
                retVal.add(InventoryUtils.isPlayerCarrying(player, (ResourceLocation)obj, 1));
                continue;
            }
            retVal.add(Boolean.TRUE);
        }
        return retVal;
    }

    public List<Boolean> getCraftRequirementCompletion(@Nullable Player player) {
        if (this.craftReference.isEmpty()) {
            return Collections.emptyList();
        }
        if (player == null) {
            return Collections.nCopies(this.craftReference.size(), Boolean.FALSE);
        }
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge(player).orElse(null);
        if (knowledge == null) {
            return Collections.nCopies(this.craftReference.size(), Boolean.FALSE);
        }
        ArrayList<Boolean> retVal = new ArrayList<Boolean>();
        for (Integer craftRef : this.craftReference) {
            retVal.add(knowledge.isResearchKnown(SimpleResearchKey.parseCrafted(craftRef)));
        }
        return retVal;
    }

    public List<Boolean> getKnowledgeRequirementCompletion(@Nullable Player player) {
        if (this.requiredKnowledge.isEmpty()) {
            return Collections.emptyList();
        }
        if (player == null) {
            return Collections.nCopies(this.requiredKnowledge.size(), Boolean.FALSE);
        }
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge(player).orElse(null);
        if (knowledge == null) {
            return Collections.nCopies(this.requiredKnowledge.size(), Boolean.FALSE);
        }
        ArrayList<Boolean> retVal = new ArrayList<Boolean>();
        for (Knowledge knowPacket : this.requiredKnowledge) {
            retVal.add(knowledge.getKnowledge(knowPacket.getType()) >= knowPacket.getAmount());
        }
        return retVal;
    }

    public List<Boolean> getResearchRequirementCompletion(@Nullable Player player) {
        if (this.requiredResearch == null || this.requiredResearch.getKeys().isEmpty()) {
            return Collections.emptyList();
        }
        if (player == null) {
            return Collections.nCopies(this.requiredResearch.getKeys().size(), Boolean.FALSE);
        }
        ArrayList<Boolean> retVal = new ArrayList<Boolean>();
        for (SimpleResearchKey key : this.requiredResearch.getKeys()) {
            retVal.add(key.isKnownByStrict(player));
        }
        return retVal;
    }
}

