/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research.topics;

import com.verdantartifice.primalmagick.common.research.topics.ResearchTopicFactory;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.StringRepresentable;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class AbstractResearchTopic
implements INBTSerializable<CompoundTag> {
    protected final Type type;
    protected String data;
    protected int page;

    protected AbstractResearchTopic(Type type, String data, int page) {
        this.type = type;
        this.data = data;
        this.page = page;
    }

    public Type getType() {
        return this.type;
    }

    public int getPage() {
        return this.page;
    }

    public AbstractResearchTopic withPage(int newPage) {
        return ResearchTopicFactory.create(this.type, this.data, newPage);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.type);
        buf.m_130070_(this.data);
        buf.m_130130_(this.page);
    }

    public CompoundTag serializeNBT() {
        CompoundTag retVal = new CompoundTag();
        retVal.m_128359_("Type", this.type.m_7912_());
        retVal.m_128359_("Data", this.data);
        retVal.m_128405_("Page", this.page);
        return retVal;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.data = nbt.m_128461_("Data");
        this.page = nbt.m_128451_("Page");
    }

    public static enum Type implements StringRepresentable
    {
        MAIN_INDEX("main_index"),
        RESEARCH_DISCIPLINE("research_discipline"),
        RESEARCH_ENTRY("research_entry"),
        SOURCE("source"),
        ENCHANTMENT("enchantment"),
        OTHER("other");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.m_7912_();
        }

        @Nullable
        public static Type fromName(@Nullable String name) {
            for (Type type : Type.values()) {
                if (!type.m_7912_().equals(name)) continue;
                return type;
            }
            return null;
        }
    }
}

