/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research.topics;

import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.research.topics.AbstractResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.DisciplineResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.EnchantmentResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.EntryResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.MainIndexResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.OtherResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.SourceResearchTopic;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public class ResearchTopicFactory {
    public static AbstractResearchTopic decode(FriendlyByteBuf buf) {
        AbstractResearchTopic.Type type = (AbstractResearchTopic.Type)buf.m_130066_(AbstractResearchTopic.Type.class);
        String data = buf.m_130277_();
        int page = buf.m_130242_();
        return ResearchTopicFactory.create(type, data, page);
    }

    public static List<AbstractResearchTopic> decodeHistory(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        LinkedList<AbstractResearchTopic> retVal = new LinkedList<AbstractResearchTopic>();
        for (int index = 0; index < size; ++index) {
            retVal.add(ResearchTopicFactory.decode(buf));
        }
        return retVal;
    }

    public static AbstractResearchTopic deserializeNBT(CompoundTag tag) {
        AbstractResearchTopic.Type type = AbstractResearchTopic.Type.fromName(tag.m_128461_("Type"));
        String data = tag.m_128461_("Data");
        int page = tag.m_128451_("Page");
        return ResearchTopicFactory.create(type, data, page);
    }

    public static AbstractResearchTopic create(AbstractResearchTopic.Type type, String data, int page) {
        switch (type) {
            case MAIN_INDEX: {
                return MainIndexResearchTopic.INSTANCE;
            }
            case RESEARCH_DISCIPLINE: {
                ResearchDiscipline disc = ResearchDisciplines.getDiscipline(data);
                return disc == null ? MainIndexResearchTopic.INSTANCE : new DisciplineResearchTopic(disc, page);
            }
            case RESEARCH_ENTRY: {
                ResearchEntry entry = ResearchEntries.getEntry(SimpleResearchKey.parse(data));
                return entry == null ? MainIndexResearchTopic.INSTANCE : new EntryResearchTopic(entry, page);
            }
            case SOURCE: {
                Source source = Source.getSource(data);
                return source == null ? MainIndexResearchTopic.INSTANCE : new SourceResearchTopic(source, page);
            }
            case ENCHANTMENT: {
                ResourceLocation loc = ResourceLocation.m_135820_((String)data);
                Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(loc);
                return ench == null ? MainIndexResearchTopic.INSTANCE : new EnchantmentResearchTopic(ench, page);
            }
            case OTHER: {
                return new OtherResearchTopic(data, page);
            }
        }
        throw new IllegalArgumentException("Unknown research topic type");
    }
}

