/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.rituals;

import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.PropMarkerPacket;
import com.verdantartifice.primalmagick.common.network.packets.fx.RemovePropMarkerPacket;
import com.verdantartifice.primalmagick.common.rituals.IRitualPropTileEntity;
import com.verdantartifice.primalmagick.common.rituals.IRitualStabilizer;
import com.verdantartifice.primalmagick.common.rituals.ISaltPowered;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IRitualPropBlock
extends ISaltPowered,
IRitualStabilizer {
    public boolean isPropActivated(BlockState var1, Level var2, BlockPos var3);

    default public void onPropActivated(BlockState state, Level world, BlockPos pos, float stabilityBonus) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof IRitualPropTileEntity) {
            IRitualPropTileEntity propTile = (IRitualPropTileEntity)tile;
            propTile.notifyAltarOfPropActivation(stabilityBonus);
        }
    }

    default public boolean isPropOpen(BlockState state, Level world, BlockPos pos) {
        IRitualPropTileEntity propTile;
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof IRitualPropTileEntity && (propTile = (IRitualPropTileEntity)tile).isPropOpen();
    }

    default public void openProp(BlockState state, Level world, BlockPos pos, @Nullable Player player, BlockPos altarPos) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof IRitualPropTileEntity) {
            IRitualPropTileEntity propTile = (IRitualPropTileEntity)tile;
            propTile.setPropOpen(true);
            PacketHandler.sendToAllAround(new PropMarkerPacket(pos), (ResourceKey<Level>)world.m_46472_(), pos, 32.0);
            if (player != null) {
                this.sendPropStatusMessage(player);
            }
        }
    }

    default public void closeProp(BlockState state, Level world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof IRitualPropTileEntity) {
            IRitualPropTileEntity propTile = (IRitualPropTileEntity)tile;
            propTile.setPropOpen(false);
            PacketHandler.sendToAllAround(new RemovePropMarkerPacket(pos), (ResourceKey<Level>)world.m_46472_(), pos, 32.0);
        }
    }

    default public void sendPropStatusMessage(@Nonnull Player player) {
        player.m_5661_((Component)Component.m_237115_((String)this.getPropTranslationKey()), false);
    }

    public String getPropTranslationKey();

    default public boolean isUniversal() {
        return false;
    }
}

