/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.rituals;

import com.verdantartifice.primalmagick.common.rituals.AbstractRitualStep;
import com.verdantartifice.primalmagick.common.rituals.RitualStepType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class UniversalRitualStep
extends AbstractRitualStep {
    protected BlockPos pos;
    protected ResourceLocation expectedId;

    public UniversalRitualStep() {
        this.pos = null;
        this.expectedId = null;
    }

    public UniversalRitualStep(BlockPos pos, ResourceLocation expectedId) {
        super(RitualStepType.UNIVERSAL_PROP);
        this.pos = pos;
        this.expectedId = expectedId;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.pos != null && this.expectedId != null;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public ResourceLocation getExpectedId() {
        return this.expectedId;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag retVal = super.serializeNBT();
        retVal.m_128405_("PosX", this.pos.m_123341_());
        retVal.m_128405_("PosY", this.pos.m_123342_());
        retVal.m_128405_("PosZ", this.pos.m_123343_());
        retVal.m_128359_("ExpectedId", this.expectedId.toString());
        return retVal;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.pos = new BlockPos(nbt.m_128451_("PosX"), nbt.m_128451_("PosY"), nbt.m_128451_("PosZ"));
        this.expectedId = new ResourceLocation(nbt.m_128461_("ExpectedId"));
    }
}

