/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.runes;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.runes.NounRune;
import com.verdantartifice.primalmagick.common.runes.PowerRune;
import com.verdantartifice.primalmagick.common.runes.RuneType;
import com.verdantartifice.primalmagick.common.runes.SourceRune;
import com.verdantartifice.primalmagick.common.runes.VerbRune;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;

public abstract class Rune {
    protected static final Map<ResourceLocation, Rune> REGISTRY = new HashMap<ResourceLocation, Rune>();
    public static final SourceRune EARTH = new SourceRune("earth", (Supplier<ResearchName>)ResearchNames.RUNE_EARTH, Source.EARTH);
    public static final SourceRune SEA = new SourceRune("sea", (Supplier<ResearchName>)ResearchNames.RUNE_SEA, Source.SEA);
    public static final SourceRune SKY = new SourceRune("sky", (Supplier<ResearchName>)ResearchNames.RUNE_SKY, Source.SKY);
    public static final SourceRune SUN = new SourceRune("sun", (Supplier<ResearchName>)ResearchNames.RUNE_SUN, Source.SUN);
    public static final SourceRune MOON = new SourceRune("moon", (Supplier<ResearchName>)ResearchNames.RUNE_MOON, Source.MOON);
    public static final SourceRune BLOOD = new SourceRune("blood", (Supplier<ResearchName>)ResearchNames.RUNE_BLOOD, Source.BLOOD);
    public static final SourceRune INFERNAL = new SourceRune("infernal", (Supplier<ResearchName>)ResearchNames.RUNE_INFERNAL, Source.INFERNAL);
    public static final SourceRune VOID = new SourceRune("void", (Supplier<ResearchName>)ResearchNames.RUNE_VOID, Source.VOID);
    public static final SourceRune HALLOWED = new SourceRune("hallowed", (Supplier<ResearchName>)ResearchNames.RUNE_HALLOWED, Source.HALLOWED);
    public static final VerbRune ABSORB = new VerbRune("absorb", (Supplier<ResearchName>)ResearchNames.RUNE_ABSORB);
    public static final VerbRune DISPEL = new VerbRune("dispel", (Supplier<ResearchName>)ResearchNames.RUNE_DISPEL);
    public static final VerbRune PROJECT = new VerbRune("project", (Supplier<ResearchName>)ResearchNames.RUNE_PROJECT);
    public static final VerbRune PROTECT = new VerbRune("protect", (Supplier<ResearchName>)ResearchNames.RUNE_PROTECT);
    public static final VerbRune SUMMON = new VerbRune("summon", (Supplier<ResearchName>)ResearchNames.RUNE_SUMMON);
    public static final NounRune AREA = new NounRune("area", (Supplier<ResearchName>)ResearchNames.RUNE_AREA);
    public static final NounRune CREATURE = new NounRune("creature", (Supplier<ResearchName>)ResearchNames.RUNE_CREATURE);
    public static final NounRune ITEM = new NounRune("item", (Supplier<ResearchName>)ResearchNames.RUNE_ITEM);
    public static final NounRune SELF = new NounRune("self", (Supplier<ResearchName>)ResearchNames.RUNE_SELF);
    public static final PowerRune INSIGHT = new PowerRune("insight", (Supplier<ResearchName>)ResearchNames.RUNE_INSIGHT, Rarity.UNCOMMON, 1);
    public static final PowerRune POWER = new PowerRune("power", (Supplier<ResearchName>)ResearchNames.RUNE_POWER, Rarity.RARE, 1);
    public static final PowerRune GRACE = new PowerRune("grace", (Supplier<ResearchName>)ResearchNames.RUNE_GRACE, Rarity.EPIC, -1);
    protected final ResourceLocation id;
    protected final Supplier<SimpleResearchKey> discoveryKey;
    protected final Rarity rarity;
    protected final boolean glint;
    protected final int limit;

    public Rune(@Nonnull String tag, @Nonnull Supplier<ResearchName> discoveryKey, @Nonnull Rarity rarity, boolean glint, int limit) {
        this(PrimalMagick.resource(tag), ResearchNames.simpleKey(discoveryKey), rarity, glint, limit);
    }

    public Rune(@Nonnull ResourceLocation id, @Nonnull Supplier<SimpleResearchKey> discoveryKey, @Nonnull Rarity rarity, boolean glint, int limit) {
        if (REGISTRY.containsKey(id)) {
            throw new IllegalArgumentException("Rune " + id.toString() + " already registered!");
        }
        this.id = id;
        this.discoveryKey = discoveryKey;
        this.rarity = rarity;
        this.glint = glint;
        this.limit = limit;
        REGISTRY.put(id, this);
    }

    @Nonnull
    public ResourceLocation getId() {
        return this.id;
    }

    @Nonnull
    public SimpleResearchKey getDiscoveryKey() {
        return this.discoveryKey.get();
    }

    @Nonnull
    public Rarity getRarity() {
        return this.rarity;
    }

    public boolean hasGlint() {
        return this.glint;
    }

    public boolean hasLimit() {
        return this.limit > -1;
    }

    public int getLimit() {
        return this.limit;
    }

    @Nonnull
    public abstract RuneType getType();

    @Nonnull
    public static Collection<Rune> getAllRunes() {
        return Collections.unmodifiableCollection(REGISTRY.values());
    }

    @Nullable
    public static Rune getRune(@Nonnull ResourceLocation tag) {
        return REGISTRY.get(tag);
    }
}

