/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.runes;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.runes.IRuneEnchantmentDefinitionSerializer;
import com.verdantartifice.primalmagick.common.runes.NounRune;
import com.verdantartifice.primalmagick.common.runes.Rune;
import com.verdantartifice.primalmagick.common.runes.SourceRune;
import com.verdantartifice.primalmagick.common.runes.VerbRune;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public class RuneEnchantmentDefinition {
    protected Enchantment result;
    protected VerbRune verb;
    protected NounRune noun;
    protected SourceRune source;
    protected CompoundResearchKey requiredResearch;

    protected RuneEnchantmentDefinition(@Nonnull Enchantment result, @Nonnull VerbRune verb, @Nonnull NounRune noun, @Nonnull SourceRune source, @Nullable CompoundResearchKey research) {
        this.result = result;
        this.verb = verb;
        this.noun = noun;
        this.source = source;
        this.requiredResearch = research;
    }

    public Enchantment getResult() {
        return this.result;
    }

    public ResourceLocation getId() {
        return ForgeRegistries.ENCHANTMENTS.getKey((Object)this.result);
    }

    public VerbRune getVerb() {
        return this.verb;
    }

    public NounRune getNoun() {
        return this.noun;
    }

    public SourceRune getSource() {
        return this.source;
    }

    public List<Rune> getRunes() {
        return List.of(this.getVerb(), this.getNoun(), this.getSource());
    }

    public CompoundResearchKey getRequiredResearch() {
        return this.requiredResearch;
    }

    public static class Serializer
    implements IRuneEnchantmentDefinitionSerializer {
        @Override
        public RuneEnchantmentDefinition read(ResourceLocation id, JsonObject json) {
            ResourceLocation verbLoc;
            Rune rune;
            ResourceLocation resultLoc = ResourceLocation.m_135820_((String)json.getAsJsonPrimitive("result").getAsString());
            if (!ForgeRegistries.ENCHANTMENTS.containsKey(resultLoc)) {
                throw new JsonSyntaxException("Invalid result in rune enchantment definition for " + id.toString());
            }
            CompoundResearchKey requiredResearch = null;
            if (json.has("required_research")) {
                requiredResearch = CompoundResearchKey.parse(json.getAsJsonPrimitive("required_research").getAsString());
            }
            if (!((rune = Rune.getRune(verbLoc = ResourceLocation.m_135820_((String)json.getAsJsonPrimitive("verb").getAsString()))) instanceof VerbRune)) {
                throw new JsonSyntaxException("Invalid verb in rune enchantment definition for " + id.toString());
            }
            VerbRune verb = (VerbRune)rune;
            ResourceLocation nounLoc = ResourceLocation.m_135820_((String)json.getAsJsonPrimitive("noun").getAsString());
            Rune rune2 = Rune.getRune(nounLoc);
            if (!(rune2 instanceof NounRune)) {
                throw new JsonSyntaxException("Invalid noun in rune enchantment definition for " + id.toString());
            }
            NounRune noun = (NounRune)rune2;
            ResourceLocation sourceLoc = ResourceLocation.m_135820_((String)json.getAsJsonPrimitive("source").getAsString());
            Rune rune3 = Rune.getRune(sourceLoc);
            if (!(rune3 instanceof SourceRune)) {
                throw new JsonSyntaxException("Invalid source in rune enchantment definition for " + id.toString());
            }
            SourceRune source = (SourceRune)rune3;
            return new RuneEnchantmentDefinition((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(resultLoc), verb, noun, source, requiredResearch);
        }

        @Override
        public RuneEnchantmentDefinition fromNetwork(FriendlyByteBuf buf) {
            ResourceLocation resultLoc = buf.m_130281_();
            if (!ForgeRegistries.ENCHANTMENTS.containsKey(resultLoc)) {
                throw new IllegalArgumentException("Unknown rune enchantment definition result " + resultLoc);
            }
            CompoundResearchKey requiredResearch = buf.readBoolean() ? CompoundResearchKey.parse(buf.m_130277_()) : null;
            ResourceLocation verbLoc = buf.m_130281_();
            Rune rune = Rune.getRune(verbLoc);
            if (!(rune instanceof VerbRune)) {
                throw new IllegalArgumentException("Unknown rune enchantment definition verb " + verbLoc);
            }
            VerbRune verb = (VerbRune)rune;
            ResourceLocation nounLoc = buf.m_130281_();
            Rune rune2 = Rune.getRune(nounLoc);
            if (!(rune2 instanceof NounRune)) {
                throw new IllegalArgumentException("Unknown rune enchantment definition noun " + nounLoc);
            }
            NounRune noun = (NounRune)rune2;
            ResourceLocation sourceLoc = buf.m_130281_();
            Rune rune3 = Rune.getRune(sourceLoc);
            if (!(rune3 instanceof SourceRune)) {
                throw new IllegalArgumentException("Unknown rune enchantment definition source " + sourceLoc);
            }
            SourceRune source = (SourceRune)rune3;
            return new RuneEnchantmentDefinition((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(resultLoc), verb, noun, source, requiredResearch);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, RuneEnchantmentDefinition data) {
            buf.m_130085_(data.getId());
            if (data.getRequiredResearch() == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.m_130070_(data.getRequiredResearch().toString());
            }
            buf.m_130085_(data.getVerb().getId());
            buf.m_130085_(data.getNoun().getId());
            buf.m_130085_(data.getSource().getId());
        }
    }
}

