/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.runes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.verdantartifice.primalmagick.common.runes.RuneEnchantmentDefinition;
import com.verdantartifice.primalmagick.common.runes.RuneManager;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="primalmagick")
public class RuneEnchantmentDefinitionLoader
extends SimpleJsonResourceReloadListener {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private static RuneEnchantmentDefinitionLoader INSTANCE;

    protected RuneEnchantmentDefinitionLoader() {
        super(GSON, "rune_enchantments");
    }

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)RuneEnchantmentDefinitionLoader.createInstance());
    }

    public static RuneEnchantmentDefinitionLoader createInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RuneEnchantmentDefinitionLoader();
        }
        return INSTANCE;
    }

    public static RuneEnchantmentDefinitionLoader getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Cannot retrieve RuneEnchantmentDefinitionLoader until resources are loaded at least once");
        }
        return INSTANCE;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        RuneManager.clearAllRuneEnchantments();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            ResourceLocation location = entry.getKey();
            if (location.m_135815_().startsWith("_")) continue;
            try {
                RuneEnchantmentDefinition def = RuneManager.DEFINITION_SERIALIZER.read(location, GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"top member"));
                if (def != null && RuneManager.registerRuneEnchantment(def)) continue;
                LOGGER.error("Failed loading rune enchantment definition {}", (Object)location);
            }
            catch (Exception e) {
                LOGGER.error("Parsing failure loading rune enchantment definition {}", (Object)location, (Object)e);
            }
        }
        LOGGER.info("Loaded {} rune enchantment definitions", (Object)RuneManager.getAllDefinitions().size());
    }

    public void replaceRuneEnchantments(Map<ResourceLocation, RuneEnchantmentDefinition> definitions) {
        RuneManager.clearAllRuneEnchantments();
        for (Map.Entry<ResourceLocation, RuneEnchantmentDefinition> entry : definitions.entrySet()) {
            if (entry.getValue() != null && RuneManager.registerRuneEnchantment(entry.getValue())) continue;
            LOGGER.error("Failed to update rune enchantment definition {}", (Object)entry.getKey());
        }
        LOGGER.info("Updated {} rune enchantment definitions", (Object)RuneManager.getAllDefinitions().size());
    }
}

