/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.runes;

import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.runes.IRuneEnchantmentDefinitionSerializer;
import com.verdantartifice.primalmagick.common.runes.NounRune;
import com.verdantartifice.primalmagick.common.runes.Rune;
import com.verdantartifice.primalmagick.common.runes.RuneEnchantmentDefinition;
import com.verdantartifice.primalmagick.common.runes.RuneType;
import com.verdantartifice.primalmagick.common.runes.SourceRune;
import com.verdantartifice.primalmagick.common.runes.VerbRune;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.registries.ForgeRegistries;

public class RuneManager {
    public static final IRuneEnchantmentDefinitionSerializer DEFINITION_SERIALIZER = new RuneEnchantmentDefinition.Serializer();
    protected static final Map<ResourceLocation, RuneEnchantmentDefinition> DEFINITIONS = new HashMap<ResourceLocation, RuneEnchantmentDefinition>();
    protected static final Map<Enchantment, List<Rune>> REGISTRY = new HashMap<Enchantment, List<Rune>>();
    protected static final Map<VerbRune, Set<Enchantment>> VERB_ENCHANTMENTS = new HashMap<VerbRune, Set<Enchantment>>();
    protected static final Map<NounRune, Set<Enchantment>> NOUN_ENCHANTMENTS = new HashMap<NounRune, Set<Enchantment>>();
    protected static final Map<SourceRune, Set<Enchantment>> SOURCE_ENCHANTMENTS = new HashMap<SourceRune, Set<Enchantment>>();
    protected static final Map<Enchantment, CompoundResearchKey> ENCHANTMENT_RESEARCH = new HashMap<Enchantment, CompoundResearchKey>();
    protected static final String RUNE_TAG_NAME = "primalmagick:runes";

    public static void registerRuneEnchantment(@Nullable Enchantment enchantment, @Nullable VerbRune verb, @Nullable NounRune noun, @Nullable SourceRune source) {
        if (enchantment != null && verb != null && noun != null && source != null) {
            if (REGISTRY.containsKey(enchantment)) {
                throw new IllegalArgumentException("Rune enchantment already registered for " + ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment).toString());
            }
            REGISTRY.put(enchantment, Arrays.asList(verb, noun, source));
            VERB_ENCHANTMENTS.computeIfAbsent(verb, r -> new HashSet()).add(enchantment);
            NOUN_ENCHANTMENTS.computeIfAbsent(noun, r -> new HashSet()).add(enchantment);
            SOURCE_ENCHANTMENTS.computeIfAbsent(source, r -> new HashSet()).add(enchantment);
        }
    }

    public static void registerRuneEnchantment(@Nullable Enchantment enchantment, @Nullable VerbRune verb, @Nullable NounRune noun, @Nullable SourceRune source, @Nullable CompoundResearchKey research) {
        RuneManager.registerRuneEnchantment(enchantment, verb, noun, source);
        if (enchantment != null && research != null) {
            ENCHANTMENT_RESEARCH.put(enchantment, research);
        }
    }

    public static boolean registerRuneEnchantment(@Nonnull RuneEnchantmentDefinition def) {
        if (DEFINITIONS.containsKey(def.getId())) {
            return false;
        }
        RuneManager.registerRuneEnchantment(def.getResult(), def.getVerb(), def.getNoun(), def.getSource(), def.getRequiredResearch());
        DEFINITIONS.put(def.getId(), def);
        return true;
    }

    public static void clearAllRuneEnchantments() {
        DEFINITIONS.clear();
        REGISTRY.clear();
        VERB_ENCHANTMENTS.clear();
        NOUN_ENCHANTMENTS.clear();
        SOURCE_ENCHANTMENTS.clear();
        ENCHANTMENT_RESEARCH.clear();
    }

    public static Map<ResourceLocation, RuneEnchantmentDefinition> getAllDefinitions() {
        return DEFINITIONS;
    }

    public static Set<Enchantment> getRuneEnchantments() {
        return Collections.unmodifiableSet(REGISTRY.keySet());
    }

    public static List<Enchantment> getRuneEnchantmentsSorted() {
        return RuneManager.getRuneEnchantments().stream().sorted((e1, e2) -> e1.m_44700_(1).getString().compareTo(e2.m_44700_(1).getString())).collect(Collectors.toList());
    }

    @Nullable
    public static List<Rune> getRunesForEnchantment(@Nullable Enchantment enchant) {
        return REGISTRY.get(enchant);
    }

    @Nonnull
    public static Map<Enchantment, Integer> getRuneEnchantments(@Nullable List<Rune> runes, @Nullable ItemStack stack, @Nullable Player player, boolean filterIncompatible) {
        if (runes == null || runes.isEmpty() || stack == null || stack.m_41619_() || player == null || !RuneManager.checkLimits(runes)) {
            return Collections.emptyMap();
        }
        List<VerbRune> verbRunes = runes.stream().filter(r -> r != null && r.getType() == RuneType.VERB).map(r -> (VerbRune)r).toList();
        List<NounRune> nounRunes = runes.stream().filter(r -> r != null && r.getType() == RuneType.NOUN).map(r -> (NounRune)r).toList();
        List<SourceRune> sourceRunes = runes.stream().filter(r -> r != null && r.getType() == RuneType.SOURCE).map(r -> (SourceRune)r).toList();
        int powerLevel = 1 + (int)runes.stream().filter(r -> r != null && r.getType() == RuneType.POWER).count();
        ArrayList<EnchantmentInstance> intermediate = new ArrayList<EnchantmentInstance>();
        for (VerbRune verb : verbRunes) {
            for (NounRune noun : nounRunes) {
                for (SourceRune source : sourceRunes) {
                    HashSet possibleEnchantments = new HashSet();
                    possibleEnchantments.addAll(VERB_ENCHANTMENTS.getOrDefault(verb, Collections.emptySet()));
                    possibleEnchantments.retainAll(NOUN_ENCHANTMENTS.getOrDefault(noun, Collections.emptySet()));
                    possibleEnchantments.retainAll(SOURCE_ENCHANTMENTS.getOrDefault(source, Collections.emptySet()));
                    for (Enchantment possible : possibleEnchantments) {
                        if (!possible.m_6081_(stack) || ENCHANTMENT_RESEARCH.containsKey(possible) && !ENCHANTMENT_RESEARCH.get(possible).isKnownByStrict(player) || powerLevel < possible.m_44702_()) continue;
                        intermediate.add(new EnchantmentInstance(possible, Math.min(powerLevel, possible.m_6586_())));
                    }
                }
            }
        }
        intermediate.sort(Comparator.comparingInt(i -> i.f_44947_.m_6183_(i.f_44948_)).reversed().thenComparingInt(i -> i.hashCode()));
        HashMap<Enchantment, Integer> retVal = new HashMap<Enchantment, Integer>();
        intermediate.forEach(instance -> {
            if (!filterIncompatible || EnchantmentHelper.m_44859_(retVal.keySet(), (Enchantment)instance.f_44947_)) {
                retVal.put(instance.f_44947_, instance.f_44948_);
            }
        });
        return retVal;
    }

    public static boolean checkLimits(@Nonnull List<Rune> runes) {
        HashMap<ResourceLocation, Integer> counts = new HashMap<ResourceLocation, Integer>();
        for (Rune rune : runes) {
            if (!rune.hasLimit()) continue;
            counts.put(rune.getId(), counts.getOrDefault(rune.getId(), 0) + 1);
            if (counts.getOrDefault(rune.getId(), 0) <= rune.getLimit()) continue;
            return false;
        }
        return true;
    }

    public static Map<Enchantment, Integer> mergeEnchantments(@Nonnull Map<Enchantment, Integer> original, @Nonnull Map<Enchantment, Integer> addition) {
        HashMap<Enchantment, Integer> retVal = new HashMap<Enchantment, Integer>(original);
        for (Map.Entry<Enchantment, Integer> entry : addition.entrySet()) {
            if (retVal.containsKey(entry.getKey())) {
                retVal.put(entry.getKey(), Math.max(original.getOrDefault(entry.getKey(), 0), entry.getValue()));
                continue;
            }
            if (!EnchantmentHelper.m_44859_(original.keySet(), (Enchantment)entry.getKey())) continue;
            retVal.put(entry.getKey(), entry.getValue());
        }
        return retVal;
    }

    public static boolean hasRunes(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_() || !stack.m_41782_()) {
            return false;
        }
        return !stack.m_41783_().m_128437_(RUNE_TAG_NAME, 8).isEmpty();
    }

    @Nonnull
    public static List<Rune> getRunes(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_() || !stack.m_41782_()) {
            return Collections.emptyList();
        }
        ArrayList<Rune> retVal = new ArrayList<Rune>();
        ListTag tagList = stack.m_41783_().m_128437_(RUNE_TAG_NAME, 8);
        for (int index = 0; index < tagList.size(); ++index) {
            String tagStr = tagList.m_128778_(index);
            Rune rune = Rune.getRune(new ResourceLocation(tagStr));
            if (rune == null) continue;
            retVal.add(rune);
        }
        return retVal;
    }

    public static void setRunes(@Nullable ItemStack stack, @Nullable List<Rune> runes) {
        if (stack != null && !stack.m_41619_() && runes != null && !runes.isEmpty()) {
            ListTag tagList = new ListTag();
            for (Rune rune : runes) {
                if (rune == null) continue;
                tagList.add((Object)StringTag.m_129297_((String)rune.getId().toString()));
            }
            stack.m_41700_(RUNE_TAG_NAME, (Tag)tagList);
        }
    }

    public static void clearRunes(@Nullable ItemStack stack) {
        if (stack != null) {
            stack.m_41749_(RUNE_TAG_NAME);
        }
    }

    public static boolean hasRuneDefinition(Enchantment enchant) {
        ResourceLocation loc = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchant);
        return loc != null && DEFINITIONS.containsKey(loc);
    }

    public static RuneEnchantmentDefinition getRuneDefinition(Enchantment enchant) {
        ResourceLocation loc = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchant);
        return loc == null ? null : (RuneEnchantmentDefinition)DEFINITIONS.getOrDefault(loc, null);
    }

    public static boolean isRuneKnown(Player player, Enchantment enchant, RuneType runeType) {
        return ResearchManager.isResearchComplete(player, SimpleResearchKey.parseRuneEnchantment(enchant)) || ResearchManager.isResearchComplete(player, SimpleResearchKey.parsePartialRuneEnchantment(enchant, runeType));
    }
}

