/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.sources;

import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.sources.IManaContainer;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ManaContainerHelper {
    public static void appendHoverText(ItemStack stack, List<Component> tooltip) {
        Player player = FMLEnvironment.dist == Dist.CLIENT ? ClientUtils.getCurrentPlayer() : null;
        CompoundTag nbt = stack.m_41737_("ManaContainerTag");
        if (nbt != null) {
            SourceList mana = SourceList.deserializeNBT(nbt);
            Source.SORTED_SOURCES.stream().filter(source -> source.isDiscovered(player) && mana.getAmount((Source)source) > 0).map(source -> Component.m_237110_((String)"tooltip.primalmagick.source.mana_container", (Object[])new Object[]{source.getNameText(), (double)mana.getAmount((Source)source) / 100.0})).forEach(tooltip::add);
        }
    }

    public static void setManaOnPlace(Level level, BlockPos pos, ItemStack stack) {
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof IManaContainer) {
            IManaContainer manaTile = (IManaContainer)tile;
            CompoundTag nbt = stack.m_41737_("ManaContainerTag");
            if (nbt != null) {
                manaTile.setMana(SourceList.deserializeNBT(nbt));
            }
        }
    }
}

