/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.sources;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.stats.Stat;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;

public class Source
implements StringRepresentable {
    public static final Map<String, Source> SOURCES = new HashMap<String, Source>();
    protected static final Map<SimpleResearchKey, Source> DISCOVER_KEYS = new HashMap<SimpleResearchKey, Source>();
    public static final Source EARTH = new Source("earth", 2125867, 0.5, ChatFormatting.DARK_GREEN, StatsPM.MANA_SPENT_EARTH);
    public static final Source SEA = new Source("sea", 1144985, 1.0, ChatFormatting.BLUE, StatsPM.MANA_SPENT_SEA);
    public static final Source SKY = new Source("sky", 8900331, 1.0, ChatFormatting.AQUA, StatsPM.MANA_SPENT_SKY);
    public static final Source SUN = new Source("sun", 16369692, 0.75, ChatFormatting.YELLOW, StatsPM.MANA_SPENT_SUN);
    public static final Source MOON = new Source("moon", 13753827, 1.0, ChatFormatting.GRAY, StatsPM.MANA_SPENT_MOON);
    public static final Source BLOOD = new Source("blood", 9044739, 1.5, ChatFormatting.DARK_RED, StatsPM.MANA_SPENT_BLOOD, SimpleResearchKey.parse("t_discover_blood"), Arrays.asList(SimpleResearchKey.parse("t_discover_forbidden"), SimpleResearchKey.parse("m_sotu_discover_blood")));
    public static final Source INFERNAL = new Source("infernal", 15544091, 2.0, ChatFormatting.GOLD, StatsPM.MANA_SPENT_INFERNAL, SimpleResearchKey.parse("t_discover_infernal"), Arrays.asList(SimpleResearchKey.parse("t_discover_forbidden"), SimpleResearchKey.parse("m_sotu_discover_infernal")));
    public static final Source VOID = new Source("void", 5577355, 2.0, ChatFormatting.DARK_PURPLE, StatsPM.MANA_SPENT_VOID, SimpleResearchKey.parse("t_discover_void"), Arrays.asList(SimpleResearchKey.parse("t_discover_forbidden"), SimpleResearchKey.parse("m_sotu_discover_void")));
    public static final Source HALLOWED = new Source("hallowed", 15657945, 3.0, ChatFormatting.WHITE, StatsPM.MANA_SPENT_HALLOWED, SimpleResearchKey.parse("t_discover_hallowed"));
    public static final List<Source> SORTED_SOURCES = Arrays.asList(EARTH, SEA, SKY, SUN, MOON, BLOOD, INFERNAL, VOID, HALLOWED);
    public static final ResourceLocation UNKNOWN_IMAGE = PrimalMagick.resource("textures/research/research_unknown.png");
    protected static final ResourceLocation UNKNOWN_ATLAS_LOC = PrimalMagick.resource("research/research_unknown");
    protected final String tag;
    protected final int color;
    protected final double observationMultiplier;
    protected final ChatFormatting chatColor;
    protected final Stat manaSpentStat;
    protected final SimpleResearchKey discoverKey;
    protected final List<SimpleResearchKey> siblings;
    protected final ResourceLocation image;
    protected final ResourceLocation atlasLoc;

    public Source(@Nonnull String tag, int color, double multiplier, @Nonnull ChatFormatting chatColor, @Nonnull Stat manaSpentStat) {
        this(tag, color, multiplier, chatColor, manaSpentStat, null);
    }

    public Source(@Nonnull String tag, int color, double multiplier, @Nonnull ChatFormatting chatColor, @Nonnull Stat manaSpentStat, @Nullable SimpleResearchKey discoverKey) {
        this(tag, color, multiplier, chatColor, manaSpentStat, discoverKey, Collections.emptyList());
    }

    public Source(@Nonnull String tag, int color, double multiplier, @Nonnull ChatFormatting chatColor, @Nonnull Stat manaSpentStat, @Nullable SimpleResearchKey discoverKey, @Nonnull List<SimpleResearchKey> siblings) {
        this(tag, color, multiplier, chatColor, manaSpentStat, discoverKey, siblings, PrimalMagick.resource("textures/sources/" + tag.toLowerCase() + ".png"), PrimalMagick.resource("sources/" + tag.toLowerCase()));
    }

    public Source(@Nonnull String tag, int color, double multiplier, @Nonnull ChatFormatting chatColor, @Nonnull Stat manaSpentStat, @Nullable SimpleResearchKey discoverKey, @Nonnull List<SimpleResearchKey> siblings, @Nonnull ResourceLocation image, @Nonnull ResourceLocation atlasLoc) {
        if (SOURCES.containsKey(tag)) {
            throw new IllegalArgumentException("Source " + tag + " already registered!");
        }
        this.tag = tag;
        this.color = color;
        this.observationMultiplier = multiplier;
        this.chatColor = chatColor;
        this.manaSpentStat = manaSpentStat;
        this.discoverKey = discoverKey;
        this.siblings = siblings;
        this.image = image;
        this.atlasLoc = atlasLoc;
        if (this.discoverKey != null) {
            DISCOVER_KEYS.put(this.discoverKey, this);
        }
        SOURCES.put(tag, this);
    }

    @Nonnull
    public String getTag() {
        return this.tag;
    }

    @Nonnull
    public String getNameTranslationKey() {
        return Source.getNameTranslationKey(this.tag);
    }

    private static String getNameTranslationKey(String tag) {
        return String.join((CharSequence)".", "source", "primalmagick", tag);
    }

    public int getColor() {
        return this.color;
    }

    public double getObservationMultiplier() {
        return this.observationMultiplier;
    }

    @Nonnull
    public ChatFormatting getChatColor() {
        return this.chatColor;
    }

    @Nonnull
    public Component getNameText() {
        return this.getNameText(this.getChatColor());
    }

    @Nonnull
    public Component getNameText(ChatFormatting format) {
        return Component.m_237115_((String)this.getNameTranslationKey()).m_130940_(format);
    }

    @Nonnull
    public Stat getManaSpentStat() {
        return this.manaSpentStat;
    }

    @Nullable
    public SimpleResearchKey getDiscoverKey() {
        return this.discoverKey;
    }

    @Nonnull
    public List<SimpleResearchKey> getSiblings() {
        return Collections.unmodifiableList(this.siblings);
    }

    @Nonnull
    public ResourceLocation getImage() {
        return this.image;
    }

    @Nonnull
    public ResourceLocation getAtlasLocation() {
        return this.atlasLoc;
    }

    public boolean isDiscovered(@Nullable Player player) {
        if (this.discoverKey == null) {
            return true;
        }
        return this.discoverKey.isKnownByStrict(player);
    }

    @Nonnull
    public static String getUnknownTranslationKey() {
        return Source.getNameTranslationKey("unknown");
    }

    @Nonnull
    public static ResourceLocation getUnknownImage() {
        return UNKNOWN_IMAGE;
    }

    @Nonnull
    public static ResourceLocation getUnknownAtlasLocation() {
        return UNKNOWN_ATLAS_LOC;
    }

    @Nullable
    public static Source getSource(@Nullable String tag) {
        return SOURCES.get(tag);
    }

    public static boolean isSourceDiscoverKey(@Nullable SimpleResearchKey key) {
        return DISCOVER_KEYS.containsKey(key);
    }

    @Nullable
    public static Source getSource(@Nullable SimpleResearchKey discoverKey) {
        return DISCOVER_KEYS.get(discoverKey);
    }

    public String m_7912_() {
        return this.getTag();
    }
}

