/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.sources;

import com.google.gson.JsonObject;
import com.verdantartifice.primalmagick.common.sources.Source;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

@Immutable
public class SourceList {
    public static final SourceList EMPTY = new SourceList();
    protected final Object2IntOpenHashMap<Source> sources;

    protected SourceList() {
        this.sources = new Object2IntOpenHashMap();
    }

    protected SourceList(SourceList other) {
        this.sources = new Object2IntOpenHashMap(other.sources);
    }

    protected SourceList(Map<Source, Integer> values) {
        this();
        values.entrySet().forEach(entry -> this.setInner((Source)entry.getKey(), (Integer)entry.getValue()));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static SourceList fromNetwork(@Nonnull FriendlyByteBuf buf) {
        Builder retVal = SourceList.builder();
        for (Source source : Source.SORTED_SOURCES) {
            retVal.with(source, buf.m_130242_());
        }
        return retVal.build();
    }

    public static void toNetwork(@Nonnull FriendlyByteBuf buf, @Nonnull SourceList sources) {
        Source.SORTED_SOURCES.stream().map(sources::getAmount).forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130130_(arg_0));
    }

    public int getAmount(@Nullable Source source) {
        return this.sources.getOrDefault((Object)source, 0);
    }

    @Nonnull
    public SourceList add(@Nullable Source source, int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount may not be negative");
        }
        if (source != null && amount > 0) {
            SourceList retVal = new SourceList(this);
            retVal.addInner(source, amount);
            return retVal;
        }
        return this;
    }

    @Nonnull
    public SourceList add(@Nullable SourceList list) {
        if (list != null && !list.isEmpty()) {
            SourceList retVal = new SourceList(this);
            for (Source source : list.getSources()) {
                retVal.addInner(source, list.getAmount(source));
            }
            return retVal;
        }
        return this;
    }

    private void addInner(@Nonnull Source source, int amount) {
        this.setInner(source, this.getAmount(source) + amount);
    }

    public SourceList reduce(@Nullable Source source, int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount may not be negative");
        }
        if (source != null && amount > 0) {
            int newAmount = this.getAmount(source) - amount;
            if (newAmount == 0) {
                SourceList retVal = new SourceList(this);
                retVal.sources.removeInt((Object)source);
                return retVal;
            }
            if (newAmount > 0) {
                SourceList retVal = new SourceList(this);
                retVal.setInner(source, newAmount);
                return retVal;
            }
        }
        return this;
    }

    @Nonnull
    public SourceList remove(@Nullable Source source) {
        if (source != null && this.sources.containsKey((Object)source)) {
            SourceList retVal = new SourceList(this);
            retVal.sources.removeInt((Object)source);
            return retVal;
        }
        return this;
    }

    @Nonnull
    public SourceList remove(@Nullable Source source, int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount may not be non-positive");
        }
        if (source != null && amount > 0) {
            int newAmount = this.getAmount(source) - amount;
            if (newAmount <= 0) {
                return this.remove(source);
            }
            SourceList retVal = new SourceList(this);
            retVal.setInner(source, newAmount);
            return retVal;
        }
        return this;
    }

    @Nonnull
    public SourceList remove(@Nullable SourceList list) {
        if (list != null && !list.isEmpty()) {
            SourceList retVal = new SourceList(this);
            for (Source source : list.getSources()) {
                int newAmount = this.getAmount(source) - list.getAmount(source);
                if (newAmount <= 0) {
                    retVal.sources.removeInt((Object)source);
                    continue;
                }
                retVal.setInner(source, newAmount);
            }
            return retVal;
        }
        return this;
    }

    @Nonnull
    public SourceList merge(@Nullable Source source, int amount) {
        if (source != null && amount > this.getAmount(source)) {
            SourceList retVal = new SourceList(this);
            retVal.setInner(source, amount);
            return retVal;
        }
        return this;
    }

    @Nonnull
    public SourceList merge(@Nullable SourceList list) {
        if (list != null && !list.isEmpty()) {
            SourceList retVal = new SourceList(this);
            for (Source source : list.getSources()) {
                retVal.setInner(source, Math.max(this.getAmount(source), list.getAmount(source)));
            }
            return retVal;
        }
        return this;
    }

    @Nonnull
    public SourceList set(@Nullable Source source, int amount) {
        if (source != null) {
            SourceList retVal = new SourceList(this);
            retVal.setInner(source, amount);
            return retVal;
        }
        return this;
    }

    @Nonnull
    public SourceList set(@Nullable SourceList list) {
        if (list != null && !list.isEmpty()) {
            SourceList retVal = new SourceList(this);
            for (Source source : list.getSources()) {
                retVal.setInner(source, list.getAmount(source));
            }
            return retVal;
        }
        return this;
    }

    private void setInner(@Nonnull Source source, int amount) {
        if (amount == 0) {
            this.sources.removeInt((Object)source);
        } else {
            this.sources.put((Object)source, amount);
        }
    }

    @Nonnull
    public SourceList multiply(int multiplier) {
        if (multiplier == 0) {
            return EMPTY;
        }
        if (multiplier == 1) {
            return this;
        }
        if (multiplier > 0) {
            SourceList retVal = new SourceList(this);
            for (Source source : this.getSources()) {
                retVal.setInner(source, multiplier * this.getAmount(source));
            }
            return retVal;
        }
        throw new IllegalArgumentException("Multiplier may not be negative");
    }

    @Nonnull
    public Set<Source> getSources() {
        return Collections.unmodifiableSet(this.sources.keySet());
    }

    @Nonnull
    public List<Source> getSourcesSorted() {
        return Source.SORTED_SOURCES.stream().filter(this::isPresent).toList();
    }

    public int getSize() {
        return this.sources.size();
    }

    public int getManaSize() {
        return this.sources.values().intStream().sum();
    }

    public boolean isEmpty() {
        return this.sources.isEmpty();
    }

    public boolean isPresent(Source source) {
        return this.getAmount(source) > 0;
    }

    @Nonnull
    public SourceList copy() {
        return new SourceList(this);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag tagList = new ListTag();
        for (Source source : this.getSources()) {
            if (source == null) continue;
            CompoundTag singleTag = new CompoundTag();
            singleTag.m_128359_("key", source.getTag());
            singleTag.m_128405_("amount", this.getAmount(source));
            tagList.add((Object)singleTag);
        }
        tag.m_128365_("Sources", (Tag)tagList);
        return tag;
    }

    public static SourceList deserializeNBT(CompoundTag nbt) {
        Builder retVal = SourceList.builder();
        ListTag tagList = nbt.m_128437_("Sources", 10);
        for (int index = 0; index < tagList.size(); ++index) {
            CompoundTag singleTag = tagList.m_128728_(index);
            if (!singleTag.m_128441_("key")) continue;
            retVal.with(Source.getSource(singleTag.m_128461_("key")), singleTag.m_128451_("amount"));
        }
        return retVal.build();
    }

    @Nonnull
    public JsonObject serializeJson() {
        JsonObject json = new JsonObject();
        for (Source source : Source.SORTED_SOURCES) {
            int value = this.getAmount(source);
            if (value <= 0) continue;
            json.addProperty(source.getTag(), (Number)value);
        }
        return json;
    }

    public Component getText() {
        List<Source> contents = this.getSourcesSorted();
        MutableComponent output = Component.m_237113_((String)"");
        for (int index = 0; index < contents.size(); ++index) {
            Source source = contents.get(index);
            if (index != 0) {
                output = output.m_7220_((Component)Component.m_237113_((String)", "));
            }
            output = output.m_7220_((Component)Component.m_237110_((String)"tooltip.primalmagick.spells.details.mana_cost.piece", (Object[])new Object[]{this.getAmount(source), source.getNameText()}));
        }
        return output;
    }

    public String toString() {
        List<String> pieces = Source.SORTED_SOURCES.stream().filter(arg_0 -> this.sources.containsKey(arg_0)).map(source -> String.join((CharSequence)"=", source.getTag(), Integer.toString(this.sources.getInt(source)))).toList();
        return "SourceList[" + String.join((CharSequence)",", pieces) + "]";
    }

    public static class Builder {
        protected final Object2IntOpenHashMap<Source> sources = new Object2IntOpenHashMap();

        protected Builder() {
        }

        public Builder with(Source source, int amount) {
            this.sources.put((Object)source, amount);
            return this;
        }

        public Builder with(SourceList list) {
            list.getSources().stream().forEach(source -> this.sources.put(source, list.getAmount((Source)source)));
            return this;
        }

        public Builder withEarth(int amount) {
            return this.with(Source.EARTH, amount);
        }

        public Builder withSea(int amount) {
            return this.with(Source.SEA, amount);
        }

        public Builder withSky(int amount) {
            return this.with(Source.SKY, amount);
        }

        public Builder withSun(int amount) {
            return this.with(Source.SUN, amount);
        }

        public Builder withMoon(int amount) {
            return this.with(Source.MOON, amount);
        }

        public Builder withBlood(int amount) {
            return this.with(Source.BLOOD, amount);
        }

        public Builder withInfernal(int amount) {
            return this.with(Source.INFERNAL, amount);
        }

        public Builder withVoid(int amount) {
            return this.with(Source.VOID, amount);
        }

        public Builder withHallowed(int amount) {
            return this.with(Source.HALLOWED, amount);
        }

        public SourceList build() {
            return new SourceList((Map<Source, Integer>)this.sources);
        }
    }
}

