/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells;

import com.verdantartifice.primalmagick.common.capabilities.IPlayerCooldowns;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.entities.projectiles.SpellMineEntity;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.SpellImpactPacket;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.mods.BurstSpellMod;
import com.verdantartifice.primalmagick.common.spells.mods.ISpellMod;
import com.verdantartifice.primalmagick.common.spells.mods.MineSpellMod;
import com.verdantartifice.primalmagick.common.spells.payloads.ISpellPayload;
import com.verdantartifice.primalmagick.common.spells.vehicles.ISpellVehicle;
import com.verdantartifice.primalmagick.common.tags.EntityTypeTagsPM;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpellManager {
    protected static final List<String> VEHICLE_TYPES = new ArrayList<String>();
    protected static final List<String> PAYLOAD_TYPES = new ArrayList<String>();
    protected static final List<String> MOD_TYPES = new ArrayList<String>();
    protected static final Map<String, Supplier<ISpellVehicle>> VEHICLE_INSTANCE_SUPPLIERS = new HashMap<String, Supplier<ISpellVehicle>>();
    protected static final Map<String, Supplier<ISpellPayload>> PAYLOAD_INSTANCE_SUPPLIERS = new HashMap<String, Supplier<ISpellPayload>>();
    protected static final Map<String, Supplier<ISpellMod>> MOD_INSTANCE_SUPPLIERS = new HashMap<String, Supplier<ISpellMod>>();
    protected static final Map<String, Supplier<CompoundResearchKey>> VEHICLE_RESEARCH_SUPPLIERS = new HashMap<String, Supplier<CompoundResearchKey>>();
    protected static final Map<String, Supplier<CompoundResearchKey>> PAYLOAD_RESEARCH_SUPPLIERS = new HashMap<String, Supplier<CompoundResearchKey>>();
    protected static final Map<String, Supplier<CompoundResearchKey>> MOD_RESEARCH_SUPPLIERS = new HashMap<String, Supplier<CompoundResearchKey>>();
    protected static final DecimalFormat COOLDOWN_FORMATTER = new DecimalFormat("#######.##");

    @Nonnull
    protected static List<String> getFilteredTypes(@Nullable Player player, @Nonnull List<String> types, @Nonnull Map<String, Supplier<CompoundResearchKey>> suppliers) {
        ArrayList<String> retVal = new ArrayList<String>();
        for (String type : types) {
            CompoundResearchKey key;
            Supplier<CompoundResearchKey> supplier = suppliers.get(type);
            if (supplier == null || (key = supplier.get()) != null && !key.isKnownByStrict(player)) continue;
            retVal.add(type);
        }
        return retVal;
    }

    @Nonnull
    public static List<String> getVehicleTypes(@Nullable Player player) {
        return SpellManager.getFilteredTypes(player, VEHICLE_TYPES, VEHICLE_RESEARCH_SUPPLIERS);
    }

    @Nullable
    public static Supplier<ISpellVehicle> getVehicleSupplier(@Nullable String type) {
        return VEHICLE_INSTANCE_SUPPLIERS.get(type);
    }

    public static void registerVehicleType(@Nullable String type, @Nullable Supplier<ISpellVehicle> instanceSupplier, @Nullable Supplier<CompoundResearchKey> researchSupplier) {
        if (type != null && !type.isEmpty() && instanceSupplier != null && researchSupplier != null) {
            VEHICLE_TYPES.add(type);
            VEHICLE_INSTANCE_SUPPLIERS.put(type, instanceSupplier);
            VEHICLE_RESEARCH_SUPPLIERS.put(type, researchSupplier);
        }
    }

    @Nonnull
    public static List<String> getPayloadTypes(@Nullable Player player) {
        return SpellManager.getFilteredTypes(player, PAYLOAD_TYPES, PAYLOAD_RESEARCH_SUPPLIERS);
    }

    @Nullable
    public static Supplier<ISpellPayload> getPayloadSupplier(@Nullable String type) {
        return PAYLOAD_INSTANCE_SUPPLIERS.get(type);
    }

    public static void registerPayloadType(@Nullable String type, @Nullable Supplier<ISpellPayload> instanceSupplier, @Nullable Supplier<CompoundResearchKey> researchSupplier) {
        if (type != null && !type.isEmpty() && instanceSupplier != null && researchSupplier != null) {
            PAYLOAD_TYPES.add(type);
            PAYLOAD_INSTANCE_SUPPLIERS.put(type, instanceSupplier);
            PAYLOAD_RESEARCH_SUPPLIERS.put(type, researchSupplier);
        }
    }

    @Nonnull
    public static List<String> getModTypes(@Nullable Player player) {
        return SpellManager.getFilteredTypes(player, MOD_TYPES, MOD_RESEARCH_SUPPLIERS);
    }

    @Nullable
    public static Supplier<ISpellMod> getModSupplier(@Nullable String type) {
        return MOD_INSTANCE_SUPPLIERS.get(type);
    }

    public static void registerModType(@Nullable String type, @Nullable Supplier<ISpellMod> instanceSupplier, @Nullable Supplier<CompoundResearchKey> researchSupplier) {
        if (type != null && !type.isEmpty() && instanceSupplier != null && researchSupplier != null) {
            MOD_TYPES.add(type);
            MOD_INSTANCE_SUPPLIERS.put(type, instanceSupplier);
            MOD_RESEARCH_SUPPLIERS.put(type, researchSupplier);
        }
    }

    public static boolean isOnCooldown(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        IPlayerCooldowns cooldowns = PrimalMagickCapabilities.getCooldowns(player);
        if (cooldowns != null) {
            return cooldowns.isOnCooldown(IPlayerCooldowns.CooldownType.SPELL);
        }
        return false;
    }

    public static void setCooldown(@Nullable Player player, int durationTicks) {
        if (player != null) {
            IPlayerCooldowns cooldowns = PrimalMagickCapabilities.getCooldowns(player);
            if (cooldowns != null) {
                cooldowns.setCooldown(IPlayerCooldowns.CooldownType.SPELL, durationTicks);
                if (player instanceof ServerPlayer) {
                    cooldowns.sync((ServerPlayer)player);
                }
            }
            player.m_36335_().m_41524_((Item)ItemsPM.SPELL_SCROLL_FILLED.get(), durationTicks);
            player.m_36335_().m_41524_((Item)ItemsPM.MUNDANE_WAND.get(), durationTicks);
            player.m_36335_().m_41524_((Item)ItemsPM.MODULAR_WAND.get(), durationTicks);
            player.m_36335_().m_41524_((Item)ItemsPM.MODULAR_STAFF.get(), durationTicks);
        }
    }

    public static void cycleActiveSpell(@Nullable Player player, @Nullable ItemStack wandStack, boolean reverse) {
        if (wandStack != null && wandStack.m_41720_() instanceof IWand) {
            IWand wand = (IWand)wandStack.m_41720_();
            int newIndex = wand.getActiveSpellIndex(wandStack) + (reverse ? -1 : 1);
            if (newIndex >= wand.getSpellCount(wandStack)) {
                newIndex = -1;
            }
            if (newIndex < -1) {
                newIndex = wand.getSpellCount(wandStack) - 1;
            }
            SpellManager.setActiveSpell(player, wandStack, newIndex);
        }
    }

    public static void setActiveSpell(@Nullable Player player, @Nullable ItemStack wandStack, int spellIndex) {
        Item item;
        if (wandStack != null && (item = wandStack.m_41720_()) instanceof IWand) {
            IWand wand = (IWand)item;
            int newIndex = Mth.m_14045_((int)spellIndex, (int)-1, (int)(wand.getSpellCount(wandStack) - 1));
            wand.setActiveSpellIndex(wandStack, newIndex);
            if (player != null) {
                SpellPackage spell = wand.getActiveSpell(wandStack);
                if (spell == null) {
                    player.m_213846_((Component)Component.m_237115_((String)"event.primalmagick.cycle_spell.none"));
                } else {
                    player.m_213846_((Component)Component.m_237110_((String)"event.primalmagick.cycle_spell", (Object[])new Object[]{spell.getName()}));
                }
            }
        }
    }

    public static void executeSpellPayload(@Nonnull SpellPackage spell, @Nonnull HitResult result, @Nonnull Level world, @Nonnull LivingEntity caster, @Nullable ItemStack spellSource, boolean allowMine, @Nullable Entity projectileEntity) {
        if (!world.f_46443_ && spell.getPayload() != null) {
            Vec3 hitVec = result.m_82450_();
            BurstSpellMod burstMod = spell.getMod(BurstSpellMod.class, "radius");
            MineSpellMod mineMod = spell.getMod(MineSpellMod.class, "duration");
            int radius = burstMod == null || allowMine && mineMod != null ? 1 : burstMod.getPropertyValue("radius");
            PacketHandler.sendToAllAround(new SpellImpactPacket(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, radius, spell.getPayload().getSource().getColor()), (ResourceKey<Level>)world.m_46472_(), BlockPos.m_274446_((Position)hitVec), 64.0);
            if (allowMine && mineMod != null) {
                SpellMineEntity mineEntity = new SpellMineEntity(world, hitVec, caster, spell, spellSource, mineMod.getDurationMinutes(spell, spellSource));
                world.m_7967_((Entity)mineEntity);
            } else if (burstMod != null) {
                Set<HitResult> targetSet = burstMod.getBurstTargets(result, spell, spellSource, world);
                for (HitResult target : targetSet) {
                    spell.getPayload().execute(target, hitVec, spell, world, caster, spellSource, null);
                }
            } else {
                spell.getPayload().execute(result, null, spell, world, caster, spellSource, null);
            }
        }
    }

    public static boolean canPolymorph(@Nonnull EntityType<?> entityType) {
        if (entityType.m_204039_(EntityTypeTagsPM.POLYMORPH_ALLOW)) {
            return true;
        }
        if (entityType.m_204039_(EntityTypeTagsPM.POLYMORPH_BAN)) {
            return false;
        }
        return !entityType.m_20674_().equals((Object)MobCategory.MISC);
    }

    @Nonnull
    public static List<Component> getSpellPackageDetailTooltip(@Nullable SpellPackage spell, @Nonnull ItemStack spellSource, boolean indent) {
        MutableComponent leader;
        ArrayList<Component> retVal = new ArrayList<Component>();
        MutableComponent mutableComponent = leader = indent ? Component.m_237113_((String)"    ") : Component.m_237113_((String)"");
        if (spell != null) {
            ISpellPayload payload;
            ISpellVehicle vehicle = spell.getVehicle();
            if (vehicle != null) {
                retVal.add((Component)leader.m_6881_().m_7220_((Component)Component.m_237110_((String)"tooltip.primalmagick.spells.details.vehicle", (Object[])new Object[]{vehicle.getDetailTooltip()})));
            }
            if ((payload = spell.getPayload()) != null) {
                retVal.add((Component)leader.m_6881_().m_7220_((Component)Component.m_237110_((String)"tooltip.primalmagick.spells.details.payload", (Object[])new Object[]{payload.getDetailTooltip(spell, spellSource)})));
            }
            ISpellMod primary = spell.getPrimaryMod();
            ISpellMod secondary = spell.getSecondaryMod();
            if (primary != null && primary.isActive() && secondary != null && secondary.isActive()) {
                retVal.add((Component)leader.m_6881_().m_7220_((Component)Component.m_237110_((String)"tooltip.primalmagick.spells.details.mods.double", (Object[])new Object[]{primary.getDetailTooltip(spell, spellSource), secondary.getDetailTooltip(spell, spellSource)})));
            } else if (primary != null && primary.isActive()) {
                retVal.add((Component)leader.m_6881_().m_7220_((Component)Component.m_237110_((String)"tooltip.primalmagick.spells.details.mods.single", (Object[])new Object[]{primary.getDetailTooltip(spell, spellSource)})));
            } else if (secondary != null && secondary.isActive()) {
                retVal.add((Component)leader.m_6881_().m_7220_((Component)Component.m_237110_((String)"tooltip.primalmagick.spells.details.mods.single", (Object[])new Object[]{secondary.getDetailTooltip(spell, spellSource)})));
            }
            retVal.add((Component)leader.m_6881_().m_7220_((Component)Component.m_237110_((String)"tooltip.primalmagick.spells.details.cooldown", (Object[])new Object[]{COOLDOWN_FORMATTER.format((double)spell.getCooldownTicks() / 20.0)})));
            if (!spellSource.m_150930_((Item)ItemsPM.SPELL_SCROLL_FILLED.get())) {
                retVal.add((Component)leader.m_6881_().m_7220_((Component)Component.m_237110_((String)"tooltip.primalmagick.spells.details.mana_cost", (Object[])new Object[]{spell.getManaCost().getText()})));
            }
        }
        return retVal;
    }
}

